# Corruption in international business: A review and research agenda

Salman Bahooa,b , Ilan Alonb , Andrea Paltrinieria, \*

a Department of Economics and Statistics, University of Udine, Via Tomadini 30/A, 33100, Udine, Italy b Department of Management, School of Business & Law, University of Agder, Gimlemoen 19, 9i 241, Post Box 422, 4604 Kristiansand, Norway

# A R T I C L E I N F O

# A B S T R A C T

JEL classification:   
E00   
E30   
D73   
B17   
K00   
D21

Keywords:   
Corruption   
Bribery   
International business   
Politics   
Bibliometric analysis   
Meta-literature review   
Firms   
Content analysis

We systematically reviewed the literature on corruption in international business (137 articles) for the last 17 years between 1992 and 2019. Additionally, we identified seven research streams in this growing literature: (1) the legislation against corruption, (2) the determinants of corruption, (3) combating corruption, 4) the effect of corruption on firms, (5) the political environment and corruption, (6) corruption as a challenge to existing theories of management, and (7) the effect of corruption on foreign direct investment and trade. Based on this review, we recommend that strong international laws are needed to minimize the negative impact of corruption on international business. Firms must also consider corruption when formulating strategies to increase operational efficiency and performance. Finally, corruption challenges some key assumptions of existing theories of management. Scholars need to test and expand these existing theories by considering corruption as an important issue in international business.

# 1. Introduction

Corruption is a multidisciplinary subject that scholars from different fields and disciplines have examined and analyzed. There are studies about corruption in many disciplines such as law (Mijares, 2015), finance (Pantzalis, Chul, & Sutton, 2008; Rose-Ackerman, 2002), economics (Brada, Drabek, & Perez, 2012; He, Xie, & Zhu, 2015), accounting (Everett, Neu, & Rahaman, 2007), and international business (Cuervo-Cazurra, 2016). However, research on corruption in international business was almost non-existent before the globalization of business in the 1980s and 1990s. Globalization prompted international business researchers to investigate and discuss the context, dimensions, models, and theories about corruption as well as its association with foreign direct investment. The first paper on corruption in international business was published in 1992, and a considerable amount of literature has accumulated on the topic during the last 17 years (see Fig. 2). However, much of this literature is scattered in numerous areas and directions. Therefore, we maintain that a systematic, in-depth review that summarizes our current knowledge is essential.

international business, we conducted a systematic, comprehensive literature review for the last 17 years between 1992 and June 2019 using bibliometric citation analysis (Fetscherin, Voss, & Gugler, 2010; White, Guldiken, Hemphill, He, & Sharifi Khoobdeh, 2016) and content analysis (Paul & Benito, 2018; Paul, Parthasarathy, & Gupta, 2017). This literature review is unique in terms of its objectives and methods, and explores several research questions: (1) What is the domain of corruption in international business? (2) What are the leading research streams? (3) What are the most influential perspectives in the literature in terms of key journals, articles, methods, data sources, measurements, and theoretical frameworks? (4) How does the literature synthesize corruption in international business? (5) What are the future research directions? As a result of our investigation, we identified 7 research streams, 6 areas in which there are gaps in our knowledge, and 14 future research questions.

In an effort to capture the richness of the literature on corruption in

Table 1 Key terms and process of selecting the sample.   

<html><body><table><tr><td colspan="5">(1)-Key terms entered into the HistCite software (HistCite - Glossary,2018)</td></tr><tr><td>Term</td><td>Sign</td><td colspan="3">Concept/Definition</td></tr><tr><td>Total global citation</td><td>(TGC) (TLC)</td><td colspan="2">TGC is the number of times an article is cited byany other articles that are available on the WoS database.</td></tr><tr><td>Total local citation</td><td></td><td colspan="2">TLC is the numberof times an article is cited by the same literature sample (in ourcase,thel37articles mentioned above).</td></tr><tr><td>Total number of articles published on the subject</td><td></td><td colspan="2">(PCIB) PCIB is the total number of articles published on corruption in international business.</td></tr><tr><td colspan="4">(2)- The processof selecting the sample from the ISI Web of Knowledge</td></tr><tr><td colspan="3">Seventeen keywords for corruption</td><td>Search in combination with the following words</td></tr><tr><td colspan="3">(1) Corruption,(2) Bribe,(3) Bribery,(4) Abuse,(5) Crime,(6) Criminal,(7) Degradation,(8) Extortion,(9) Falsification, (10) Fraud,(11) Graft,(12) Manipulating,(13) Manipulation,(14) Misconduct,(15) Misconduct, (16) misrepresentation,and (17) wrongdoing.</td><td>International Business, Multinational Enterprise, Multinational Corporation, MNEs, MNCs.</td></tr><tr><td colspan="3">Filters applied to search in the ISI Web of Knowledge</td></tr><tr><td>(1) Search filters</td><td colspan="2">Topic (Search keywords in “Title,keywords,and Abstract&quot;)</td></tr><tr><td>(2) Paper type and language</td><td colspan="2">Articles and English.</td></tr><tr><td>(3) Period of search</td><td colspan="2">1950 to June 2019 (1st paper published in 1992 on the subject)</td></tr></table></body></html>

Note: The table lists the terms used to search the database to obtain the sample, and the data entered into the HistCite software.

# 2. A taxonomy of corruption in international business

# 2.1. The definition of corruption

Synthesizing the literature, we define corruption as “an illegal activity (bribery, fraud, financial crime, abuse, falsification, favoritism, nepotism, manipulation, etc.) conducted through misuse of authority or power by public (government) or private (firms) officeholders for private gain and benefit, financial or otherwise.” Our definition of corruption captures three important characteristics of corruption in the international business context. The first is that the person or firm is conducting some form of illegal activity. The second is that the person or firm is misusing power or authority in violation of existing rules and regulations or acting beyond legal limits. The third characteristic is that the person or firm is using a position of power to reap personal benefits (financial or otherwise) instead of benefiting the nation or the shareholders. Our definition is intended to be inclusive of all forms of corruption, including bribery, fraud, financial crimes, abuse, falsification, favoritism, nepotism, manipulation, and misrepresentation by public or private officials, domestically or internationally, in a social, business, or governmental context.

# 2.2. Types and causes of corruption

Different types of corruption are documented in the literature and include public corruption (Pontell & Geis, 2007), private corruption (Argandona, 2003), pervasive corruption, and arbitrary corruption (Rodriguez, Uhlenbruck, & Eden, 2005). Public corruption is further divided into four types: petty vs. grand corruption (Elliott, 1997) and organized vs. unorganized corruption (Shleifer & Vishny, 1993).

Public corruption can be defined as an illegal activity conducted by a government official, bureaucrat, or politician that involves the offer or receipt of financial or non-financial benefits by other government or private persons. Public corruption is classified as petty when small gifts or favors are exchanged, and as grand when large sums of money are exchanged. Public corruption is further classified as organized when it is planned, and the individuals or firms involved must pay a lump sum, and as unorganized when it is unplanned, and the individuals or firms involved pay an unspecified sum at every step of the illegal activity. In contrast to public corruption, private corruption can be defined as an illegal activity conducted by an employee, manager, or firm that involves the offer or receipt of benefits by other private or government persons. Private corruption is classified as pervasive when the employee or manager can be certain of the necessity for bribery when dealing with government officials, and as arbitrary otherwise (Cuervo-Cazurra, 2016, p. 38).

Corruption can originate from either the “demand side” (the recipients of the bribe) or the “supply side” (the givers of the bribe) (Heimann & Boswell, 1998). Public and private corruption are associated with the demand side and supply side, respectively. In the international business context, Cuervo-Cazurra (2016) suggests that the demand-side incentives of government officials be distinguished from the supply-side incentives of managers. Everett, Neu, and Rahaman (2006) maintain that the demand side of corruption is the activity of a few “rotten eggs” that takes place at the individual level due to “resource scarcity.” Hamir (1999) shows that private corruption originates at the organizational level when good governance procedures and proper oversight are lacking. Caiden, Dwivedi, and Jabbra (2001) argue that both public and private corruption are endemic in individualistic societies where people are not exposed to traditional or collectivistic norms and education. Furthermore, they provide evidence that supplyside corruption in foreign investment commonly involves foreign investors who offer bribes to government officials.

# 3. Methods

To conduct this review, we adopted a unique approach that coupled bibliometric citation analysis (Bahoo, Alon, & Paltrinieri, 2019; Fetscherin et al., 2010; Iddy & Alon, 2019; Naatu & Alon, 2019; White et al., 2016) and content analysis (Paul & Benito, 2018; Paul & RosadoSerrano, 2019; Paul & Singh, 2017; Paul et al., 2017; Rosado-Serrano, Paul, & Dikova, 2018). Price (1965) first championed bibliometric analysisto explore the relationships between articles based on the number of citations (Kim & McMillan, 2008), using the article as the basic unit of analysis (Alon, Anderson, Munim, & Ho, 2018). We used HistCite software for the bibliometric analysis. We present the key terms related to the bibliometric analysis in Table 1. Content analysis, which is an accepted methodology in the social sciences (Ahmed, Bahoo, Aslam, & Qureshi, 2020; Bahoo, Saeed, Iqbal, & Nawaz, 2018; Gaur & Kumar, 2018), classifies textual material by reducing it to more relevant, manageable bits of data (Weber, 1990). Our method, illustrated in Fig. 1, involves three steps: sample selection and data collection, analysis, and results (Gomezelj, 2016).

![](images/890df11114148801d81080f6def3704c4647cbccf842f4c8c79767c2839ff6ac.jpg)  
Fig. 1. Methodological approach.

# 3.1. Sample selection and data collection

Our data collection involves three steps. First, we selected the journals from which to collect articles and citation data on the subject. To avoid selection bias in considering only top-ranked or international business journals (Terjesen, Hessels, & Li, 2013), we searched all of the journals that are listed on the ISI Web of Knowledge (henceforth WoS) database. The WoS consists of five databases covering several disciplines and provides citation data about articles dating back to 1950 (Alon et al., 2018).

The second step was to choose the sample period and the search technique. We searched all of the articles on corruption in international business published between 1950 and June 2019 using a variety of keywords. By following Alon et al. (2018), Fetscherin et al. (2010), and White et al. (2016), we used 17 keywords for corruption in combination with words such as “international business, multinational enterprises, multinational corporations, MNEs, and MNCs” to cover the complete literature on the topic. Table 1 lists the 17 keywords for corruption and key filters applied to search the literature. These searches yielded 322 articles of potential interest that we examined cursorily to confirm their relevance.

In the third step, two independent researchers read through and critically examined the 322 articles using the following criteria: the article must explicitly state that it is about corruption in international business, and it must address the subject in a non-trivial and nonmarginal way. After excluding irrelevant articles, our resulting dataset contained 137 articles. The first paper to address corruption in international business explicitly was published in 1992. As Fig. 2 illustrates, there has been continuous growth in the literature.

# 3.2. Analysis

We utilized various complementary tests such as (1) co-citation analysis, (2) citation analysis, and (3) content analysis during four stages of analysis. In the first stage, we identified research streams in the literature through bibliometric co-citation analysis (Dzikowski, 2018; Fetscherin et al., 2010; Øyna & Alon, 2018; Paltrinieri, Hassan, Bahoo, & Khan, 2019). We used the HistCite software program, which accepts citation data as inputs and provides several outputs, for bibliometric analysis. In the second stage, we identified influential aspects of the literature, such as key journals, articles, methods, data sources, measurements of corruption, and theoretical frameworks (RosadoSerrano et al., 2018). In the third stage, we created a taxonomy and synthesis of the literature on corruption in international business (Carvalho, Isnard, De Almeida, & Rosa, 2014). Finally, through our analysis, we presented propositions and questions for future research (Fernando & Serra, 2014; Paul & Benito, 2018).

![](images/86f70bdd468b4478ccbdaf3e4849bee42f9a10dc32157f5a105e1fa17626e9e9.jpg)  
Fig. 2. Publications on corruption in IB between 1950 to June $2 0 1 9 ^ { \ast }$ . \*The first article on subject published in 1992.

![](images/2a7264ba650475d1a18e467d87a3a939d46d771d264b3d5190a3beeca745d76b.jpg)  
Fig. 3. Citation map of the literature on corruption in IB. The HistCite software is used to create map. $^ { * } 7 6$ articles form this map. For details see Table A1.

# 4. Results

# 4.1. Co-citation mapping: Research streams in the literature on corruption in international business

Co-citation mapping is the mapping of top-cited papers in relation to the papers that cite them (Alon et al., 2018). Co-citation mapping is conducted through HistCite software. We established the criteria to identify the mapping by following Alon et al. (2018), Apriliyanti and Alon (2017), and Øyna and Alon (2018). However, the criteria depend on the nature of the subject and the growth of the literature. Therefore, we utilized a two-level procedure. First, to be included in the mapping, an article must have a minimum of one total local citation $\mathrm { ( T L C } \geq 1 \dot { }$ ). We identified 37 influential articles as a subsample. We then included all articles that cited these 37 influential articles in the mapping. As a result, we added 39 more papers to the subsample. Thus, the co-citation map has 76 articles, details of which appear in Table A1 (Fig. 3).

In Fig. 3, articles, represented by nodes, are positioned along the horizontal axis, and years of publication are positioned along the vertical axis. Co-citation linkages are depicted by lines that connect the nodes, and citing vs. cited articles are indicated by arrows. The size of the node reflects the magnitude of influence of an article based on total local citations received (TLC). In our citation map, the largest nodes are 20 (i.e., Rodriguez et al., 2005), 21 (Sanyal, 2005), 24 (Uhlenbruck, Rodriguez, Doh, & Eden, 2006), and 14 (Doh, Rodriguez, Uhlenbruck, Collins, & Shekshnia, 2003).

We then asked two independent researchers to conduct the content analysis of the subsample of 76 articles. The content analysis consists of a critical review of each article’s title, author, journal, research question (s), theory, data sources, variables, category, and key findings (Ahmed, Bahoo, & Ayub, 2019; Bahoo, Hassan, Paltrinieri, & Khan, 2019; Salipante, Notz, & Bigelow, 1982). As a result of this content analysis, combined with our bibliometric analysis, we were able to identify seven distinctly but interrelated research streams in the literature on corruption in international business: (1) the legislation against it, (2) its determinants, (3) combating it, (4) its effect on firms, (5) the political environment and corruption in international business, (6) corruption as a challenge to existing theories of management in international business, and (7) corruption’s effect on foreign direct investments and trade (see Fig. 3). We were also able to identify some outliers, namely, articles not cited by other articles but whose content fits in one or more of the research streams (1, 3, 36, 114, 105, 12, 102, 91, 60, and 15). We discuss these articles in their relevant research streams. The numbers refer to Fig. 3. However, there are two articles cited by other articles but whose content does not fit in any of the research streams (102 and 115) (Jiménez & Bjorvatn, 2018). Lord and Levi (2017) (no. 102 in Fig. 3) and Karhunen, Kosonen, Mccarthy, and Puffer (2018) (no. 115 in Fig. 3) discuss the financial aspects of corruption related to money laundering and corrupt exchanges in Chinese Guanxi and Russian Blat/ Svyazi, respectively. We now discuss the seven research streams.

# 4.1.1. The legislation against corruption in international business

In the 1990s, corruption emerged as a global political issue with dire implications for international business (Kaikati, Sullivan, Virgo, Carr, & Virgo, 2000) and remained a persistent problem despite the passage of national and international legislation to control it (Nichols, 2012). Everett et al. (2006) (no. 23 in Fig. 3) argue that existing anticorruption laws need to be updated by all relevant regulatory bodies. The United States was the first country to pass laws prohibiting corruption by individuals or firms, namely, the 1977 Foreign Corrupt Practices Act (FCPA) (Hotchkiss, 1998) (no. 4 in Fig. 3). However, Klaw (2012) (no. 60 in Fig. 3) maintains that the FCPA is unable to prevent and punish demand-side corruption in business transactions. Kaikati et al. (2000) (no. 9 in Fig. 3) have recommended that the OECD broaden the scope of the FCPA and adopt the amended version in full. In 1997, for the first time, the UN, OECD, and EU convened to discuss passing legislation against bribery and corruption (Mijares, 2015) (no. 80 in Fig. 3). The guidelines of the UN’s 1996 declaration, the OECD’s 1997 convention, and the EU’s 1997 convention were the foundation of current anti-corruption laws (Gantz, 1998). Under these guidelines many developed and emerging economies have established national anti-corruption laws in international business, including Canada (Mijares, 2015) (no. 80 in Fig. 3), the US (Spalding, 2011) (no. 54 in Fig. 3), and the EU (Pacini, Swingen, & Rogers, 2002) (no. 11 in Fig. 3). Moreover, the OECD convention provides guidelines for member states to establish uniform laws and policies (Pacini et al., 2002). Implementation of the OECD’s 1997 convention is compulsory for the 36 signatory countries.

# 4.1.2. The determinants of corruption in international business

The dominant research stream in the literature is the determinants of corruption in international business. Carmichael (1995) presents three common situations in which a multinational enterprise becomes involved in corruption in a host country. The first is when the company is unable to engage in a new business transaction or complete an existing one without offering a bribe. The second is when the legal institutions in the host country are weak. The third is when the multinational firm is involved in corruption in its home country as well.

One group of studies argues that the determinant of corruption is the firm. Chen, Cullen, and Parboteeah (2015) (no. 82 in Fig. 3) explore the relationship between culture, management, shareholder control, and a firm’s propensity to bribe. They find that manager-controlled firms are more likely than shareholder-controlled firms to engage in bribery.

The second group of studies maintains that the determinant of corruption is cultural factors. Based on a survey they conducted, Guvenli and Sanyal (2012) (no. 56 in Fig. 3) explore whether attitudes toward bribery differ between men and women in international business. They found that men are more inclined toward bribery than women. Recently, Tuliao and Chen (2017) (no. 99 in Fig. 3) analyzed gender as a determinant of bribery among CEOs and found that male CEOs are more likely to be involved in corruption. Relatedly, Frei, and Muethel (2017) (no. 103 in Fig. 3) argue that the host country provides a breeding ground for multinational firms for corruption through weak values and laws. Therefore, regional characteristics are significant determinants of corruption (Sanyal & Samanta, 2017) (no. 98 in Fig. 3).

Finally, the third group of studies claims that the determinant of corruption is economic factors. Sanyal (2005) (no. 21 in Fig. 3) suggests that countries with low per capita income and poor income distribution, and those that score high on Hofstede’s scales of power distance and masculinity are more inclined toward bribery. Similarly, Sanyal and Guvenli (2009) (no. 33 in Fig. 3) show that firms from countries where the power distance or the long-term orientation is low, and individualism is high are less involved in corruption. Baughn, Bodie, Buchanan, and Bixby (2010) (no. 41 in Fig. 3) confirm that firms from countries that score high on power distance are more likely to be involved in bribery. Mazar and Aggarwal (2011) (no. 51 in Fig. 3) find that bribery varies with the degree of collectivism. Huang, Liu, Zheng, Tan, & Zhao, 2015 (no. 81 in Fig. 3) argue that concern about evaluations plays a moderating role between collectivism and corruption: collectivism facilitates corruption in countries where there is little concern about evaluations.

# 4.1.3. Combating corruption in international business

Laws and regulations against corruption exist but are largely ineffective due to weak judicial systems and the indifference of governments (Cuervo-Cazurra, 2008). The major research question in this stream is related to the practical effectiveness of laws, the adoption of ethical standards, and the implementation of legal frameworks to combat corruption.

Hotchkiss (1998) (no. 4 in Fig. 3) argues that the 1977 Foreign Corrupt Practices Act was considered just a moral obligation until the US government began enforcing it in 1998. Kaczmarek and Newman (2011) show that extraterritorial intervention by US prosecutors to reduce corruption and bribery in target countries is effective. Weber and Getz (2004) (no. 17 in Fig. 3) review the efforts of the EU, US, and OECD to combat corruption. Cuervo-Cazurra (2008) (no. 30 in Fig. 3) advocates an increase in the scope of implementation of existing anticorruption laws and a reduction in investment in corrupt countries by signatories to the OECD convention.

Rose-Ackerman (2002) (no. 12 in Fig. 3) considers abstention from corruption to be the moral responsibility of the firms and argues that the formation of ethical standards can be helpful in this regard. Kaptein (2004) (no. 15 in Fig. 3) reviews the business codes and standards of 200 of the largest firms and finds that $4 6 \%$ of them have ethical codes against corruption. Osuji (2011) (no. 52 in Fig. 3) highlights the importance of ethical corporate social responsibility (CSR) to combat corruption. Rodriguez et al. (2005) (no. 20 in Fig. 3) analyze the effect of public corruption on multinational enterprises in terms of organizational legitimacy, strategic decision-making, and entry choice. Cleveland et al. (2010) (no. 39 in Fig. 3) build a model based on hard and soft laws, and enforcement and compliance mechanisms to assess progress in reducing the level of bribery.

# 4.1.4. The effect of corruption on firms in international business

How does corruption affect the entry strategy of a company, international joint ventures, and the performance of subsidiaries? Uhlenbruck et al. (2006) (no. 24 in Fig. 3) examine the effect of corruption on firms’ entry strategies in foreign markets and find that firms in the telecommunication industry face pressure to engage in corrupt practices during short-term contracts and joint ventures. Kouznetsov, Dass, and Schmidt (2014) (no. 70 in Fig. 3) confirm the negative effect of weak laws against corruption on small-to-medium-sized foreign manufacturing enterprises in Russia. Roy and Oliver (2009) (no. 37 in Fig. 3) show that the rule of law and control of corruption have a strong impact on the selection of partners for joint ventures. Krueger (2009) (no. 38 in Fig. 3) argues that international firms doing business in China face ethical issues due to the authoritarian government, lack of transparency, and the high level of corruption.

Jensen, Li, and Rahman (2010) (no. 46 in Fig. 3) report that in a political environment where freedom of the press is restricted, firms utilize a no-comment or false disclosure option as a self-protection strategy. Lambsdorff (2013) (no. 65 in Fig. 3) argues that firms should be liable for the illegal activities of the corrupt intermediaries with whom they engage in business transactions. Petrou (2014) (no. 84 in Fig. 3) finds that arbitrary corruption hurts the performance of subsidiaries. Finally, Gomes, Vendrell-herrero, Mellahi, Angwin, and Sousa (2018) (no. 106 in Fig. 3) provide evidence that the self-selection theory works only in environments with a low level of corruption.

# 4.1.5. The political environment and corruption in international business

This research stream examines the link between corruption, international business, and the political environment in the host and home countries. Rodriguez, Siegel, Eden, and Hillman (2006) (no. 25 in Fig. 3) review papers on the link between politics, corruption, and corporate social responsibility and propose some future research directions. Luo (2006) (no. 26 in Fig. 3) uses a structuration model to show that in a highly corrupt environment, multinational enterprises with a high level of ethics bargain with governments, while less ethical firms use social and political connections to engage in bribe-giving. Chen, Ding, and Kim (2010) (no. 47 in Fig. 3) find that corruption has more influence on the earnings forecasts of highly politically connected firms than less politically connected ones. Boubakri, Mansi, and Saffar (2013) (no. 64 in Fig. 3) document that sound political institutions have a positive effect on corporate risk-taking when government extraction is high, and the level of corruption is low. Yim, Lu, and Choi (2017) (no. 100 in Fig. 3) show that in business transactions, political lobbying has a more positive impact on firm performance than bribery. Brockman, Rui, and Zou (2013) (no. 67 in Fig. 3) find that where there are strong legal institutions or a low level of corruption, politically connected firms’ post-merger and acquisition performance is low compared to that of non-political firms. Hung, Kim, and Li (2018) (no. 112 in Fig. 3) argue that politically non-connected firms issue more management forecasts than politically connected firms.

Table 2 Key journals in the literature on corruption in IB.   

<html><body><table><tr><td>#</td><td>Journals</td><td>No.of articles</td><td>Global Citations (TGC)</td><td>References</td></tr><tr><td>1</td><td>Journal of Business Ethics</td><td>18</td><td>551</td><td>Armstrong,1992; Tsalikis &amp; Latour,1995; Kaikati et al., 2000; Pacini et al., 2002; Kaptein, 2004; Sanyal, 2005; Everett et al., 2006; Argandona, 2007; Peng &amp; Beamish, 2008; Koerber, 2010; Pedigo &amp; Marshall, 2009; Krueger, 2009; Cleveland et al., 2009; Baughn et al., 2010;</td></tr><tr><td>2</td><td>Journal of International Business Studies</td><td>13</td><td>908</td><td>Darrough, 2010; Osuji, 201l; Blanc et al., 2019; Horak, 2018. Rodriguez et al., 2006; Luo,2006; Cuervo-Cazurra, 2006, 2008; Pajunen, 2008; Roy &amp; Oliver, 2009; Franke &amp; Richey, 2010; Jensen et al., 2010; Chen et al., 2010; Muethel et al., 2011;</td></tr><tr><td></td><td>International Business Review</td><td>6</td><td>73</td><td>Boubakri etal., 2013; Brockman et al., 2013; Hung etal., 2018. Jiménez,2010; Driffield et al.,2013; Roy&amp; Goll, 2014; Yi etal.,2017; Krammer et al., 2018;</td></tr><tr><td>4</td><td>Journal of World Business</td><td>6</td><td>54</td><td>Guo, Rammal, Benson, Zhu, &amp; Dowling, 2018. Hearn, 2015; Petrou, 2015; Cuervo-Cazurra, 2016; Drifeld etal., 2016; Xie, Reddy,&amp; Liang,</td></tr><tr><td>5</td><td>Business Ethics Quarterly</td><td>3</td><td>38</td><td>2017; Lewellyn &amp; Rosey, 2017. Weber &amp; Getz, 2004; Windsor, 2004; Gelbrich et al., 2016</td></tr><tr><td>6</td><td>Journal of International Management</td><td>3</td><td>21</td><td>Tunyi&amp; Ntim, 2016; Geleilate etal., 2016; Muellner etal., 2017</td></tr><tr><td>7</td><td>Journal of Management Studies</td><td>2</td><td>114</td><td>Galang,2012; Keig et al., 2015</td></tr><tr><td>8</td><td>Asia Pacific Journal of Management</td><td>2</td><td>29</td><td>Meschi, 2009; Lee &amp; Hong, 2012</td></tr><tr><td>9</td><td>Journal of Business Research</td><td>2</td><td>4</td><td>Czinkota &amp; Skuba, 2014;Hub &amp; Shing, 2016</td></tr><tr><td>10</td><td>Management and Organization Review</td><td>2</td><td>2</td><td>Chen et al., 2015; Karhunen et al., 2018</td></tr><tr><td>11</td><td>Management International Review</td><td>2</td><td>26</td><td>Czinkota &amp; Ronkainen, 2019; Jiménez, Marcelus, Guoliang,&amp; Jiang, 2017</td></tr><tr><td></td><td>Academy of Management Executive</td><td>1</td><td>104</td><td>Doh et al., 2003</td></tr><tr><td>12</td><td>Academy of Management Journal</td><td>1</td><td>178</td><td>Martin, Cullen, Johnson,&amp; Parboteeah, 2019</td></tr><tr><td>13</td><td>Academy of Management Review</td><td></td><td>200</td><td>Rodriguez et al., 2005</td></tr><tr><td>14</td><td>Administrative Science</td><td></td><td>2</td><td>Lord, Wingerde,&amp; Campbell, 2018</td></tr><tr><td>14</td><td>Economica</td><td></td><td>2</td><td>Celentani, Ganuza,&amp; Peydro, 2004</td></tr><tr><td>15</td><td>International Marketing Review</td><td></td><td>0</td><td>Gomes et al., 2018</td></tr><tr><td>16</td><td>Journal of Banking &amp; Finance</td><td>1</td><td>39</td><td>Rose-Ackerman, 2002</td></tr><tr><td>17</td><td>Journal of Comparative Economics</td><td>1</td><td>18</td><td>Perez, Brada, &amp; Drabek, 2012</td></tr><tr><td>18</td><td></td><td></td><td>12</td><td>Pantzalis et al., 2008</td></tr><tr><td>19</td><td>Journal of Empirical Finance Journal of Management Inquiry</td><td>1</td><td>0</td><td>Frei &amp; Muethel, 2017</td></tr><tr><td>20</td><td></td><td></td><td>150</td><td></td></tr><tr><td>21</td><td>Organization Science Psychological Science</td><td>1</td><td>59</td><td>Uhlenbruck et al., 2006</td></tr><tr><td>22</td><td>Corporate Governance-An</td><td>1</td><td>51</td><td>Mazar &amp; Aggarwal, 2011 Bondy et al., 2008</td></tr><tr><td></td><td>International Review Cross Cultural Management-An</td><td></td><td></td><td>Sanyal &amp; Guvenli, 2009</td></tr><tr><td>23</td><td>International Journal</td><td></td><td>0</td><td></td></tr><tr><td>24 25</td><td>Baltic Journal of Management European Journal of International</td><td>1 1</td><td>3 0</td><td>Kouznetsov et al., 2014 Oesterle &amp; Bjorn, 2017</td></tr><tr><td></td><td>Management European Journal of Law and</td><td>1</td><td>10</td><td>Lambsdorff, 2013</td></tr><tr><td>26</td><td>Economics International Journal of Emerging</td><td></td><td>6</td><td>Dikova et al., 2016</td></tr><tr><td>27</td><td>Markets</td><td></td><td></td><td></td></tr><tr><td>28 29</td><td>Journal of East-West Business Management Decision</td><td>1 1</td><td>0 3</td><td>Sanyal &amp; Samanta, 2017 Tuliao &amp; Chen, 2017</td></tr><tr><td>30</td><td>Multinational Business Review</td><td>1</td><td>2</td><td>Yim et al., 2017</td></tr><tr><td>31</td><td>Post-Communist Economies</td><td>1</td><td>6</td><td>He et al., 2015</td></tr><tr><td>32</td><td>Review of Development Economics</td><td>1</td><td>17</td><td>Brada et al., 2012</td></tr><tr><td>33</td><td></td><td></td><td>0</td><td>Mijares, 2015</td></tr><tr><td></td><td>Western Journal of Legal Studies Culture and Organization</td><td>1</td><td></td><td>Maria, 2010</td></tr><tr><td>34</td><td></td><td>1</td><td>3</td><td></td></tr><tr><td>Total</td><td></td><td>84</td><td>2685</td><td>(61 % of total 137 articles)</td></tr></table></body></html>

Note: The table shows the list of key journals (ABS ranking $4 ^ { * }$ , 4, 3, 2 and 1) that published articles in our sample.

# 4.1.6. Corruption as a challenge to existing theories of management in international business

The sixth research stream is relatively new and at the fact-finding and evaluation stage. It often provides counterexamples to many existing theories of management in international business because the unethical, criminal nature of corruption challenges certain assumptions of those theories. For example, Gomes et al. (2018) (no. 106 in Fig. 3) find that contrary to the self-selection theory, if the level of corruption is high, productivity does not have a positive effect on the value of exports. After reviewing the literature related to the firm’s response to government corruption, Galang (2012) (no. 58 in Fig. 3) summarizes the key theories that support its strategies, such as institutional economics, institutionalism, resource dependence, public choice, social network, and stakeholder theory. Doh et al. (2003) (no. 14 in Fig. 3) explore the impact of government corruption on multinational enterprises. They provide a framework based on two dimensions of government corruption: pervasiveness and arbitrariness. The framework proposes several strategies that firms should adopt to respond to corruption: avoidance, adjusting their entry mode, corporate codes of conduct, training, development and public education, social contributions and public donations, and laws and agreements. Cuervo-Cazurra (2016) (no. 88 in Fig. 3) proposes expanding this approach by considering corruption as a laboratory. He reviews and recommends extensions of several theories: agency theory, transaction cost economics, the resource-based view, resource dependence, and neo-institutional theory. He also argues that the agency and resource-dependence theories are best for explaining the causes of corruption, whereas the resource-based view and neo-institutional theory are more appropriate for exploring the consequences of corruption. Transaction cost theory is best for determining how to control corruption in international business.

# 4.1.7. The effect of corruption on foreign direct investment and trade in international business

The seventh research stream is also in the fact-finding and evaluation stage. It examines the impact of home- and host-country corruption on foreign direct investment and trade. Habib and Zurawicki (2002) find that corruption has a negative effect on foreign direct investment and operational efficiency. Cuervo-Cazurra (2006) (no. 27 in Fig. 3) shows that firms from countries with a high level of corruption are more likely to invest in host countries with a high level of corruption than firms from less corrupt countries. Driffield, Jones, and Crotty (2013) (no. 63 in Fig. 3) argue that firms from countries with a high level of corruption, weak legal institutions, and less concern about corporate social responsibility are more likely to invest in host countries with a high level of corruption. Sambharya and Rasheed (2015) argue that if the level of corruption is low, economic and political freedom has a positive effect on foreign direct investment and trade. Jiménez, Marcelus, Guoliang, & Jiang, 2017 (no. 104 in Fig. 3) show that hostcountry corruption is positively related to a high failure rate of private participation projects. However, Egger and Winner (2005) demonstrate that corruption stimulates foreign direct investment. Driffield, Jones, and Crotty (2013) (no. 63 in Fig. 3) argue that firms from corrupt countries are very involved in investment in corrupt locations and countries.

# 4.2. Influential aspects of the literature on corruption in international business

We identified the key journals, studies, methods, data sources, measurements, and theoretical frameworks in the literature (Alon et al., 2018; Paul & Benito, 2018; Paul et al., 2017). In Section 6, we also highlighted the gaps in our knowledge and posited several propositions.

# 4.2.1. Key journals

The 137 articles in our sample came from 85 journals with 3059 total global citations. Table 2 lists the 34 leading journals having an ABS ranking $( 4 ^ { * }$ , 4, 3, 2, 1). We do not report the remaining 51 journals due to space limitations. Sixty-one percent of our sample accounted for 2685 of the citations. The largest number of articles was published by the Journal of Business Ethics (JBE) (18 articles), Journal of International Business Studies (JIBS) (13 articles), International Business Review (IBR) (6 articles), and Journal of World Business (JWB) (6 articles). This ranking is logical, given that the first journal is the leading publication outlet in the field of ethics and business, and the second is the oldest and most prominent journal. The fact that we found articles on this topic in journals devoted to financing and law confirms its multidisciplinary nature.

# 4.2.2. Key studies

Through bibliometric citation analysis, we identified key empirical and theoretical papers that had at least 10 global citations $( \mathrm { T G C } \ge 1 0 )$ . Tables 3 and 4 provide summaries of these empirical and theoretical papers, respectively, through content analysis. Note that in previous literature, empirical papers have received more citations than theoretical ones. The most cited articles refer to the effect of corruption on firms in international business (Hearn, 2015; Jensen et al., 2010; Jiménez, 2010; Keig, Brouthers, & Marshall, 2015; Lee & Hong, 2012; Meschi, 2009; Mazar & Aggarwal, 2011; Muethel, Hoegl, & Parboteeah, 2011; Pantzalis et al., 2008; Roy & Oliver, 2009; Tunyi & Ntim, 2016; Uhlenbruck et al., 2006), confirming that the firm is the topic of most interest.

# 4.2.3. Key methods

The researchers utilized qualitative and quantitative methods in the literature to explore corruption in international business (see Table 5). Out of 137 articles, 35 $( 4 0 ~ \% )$ ) used content analysis, 37 $( 4 8 ~ \% )$ used regression analysis, and 12 $( 8 \% )$ used document analysis. Researchers used content analysis to formulate concepts, theoretical backgrounds, and models related to corruption (Cuervo-Cazurra, 2016; Everett et al., 2006; Kaptein, 2004; Krueger, 2009; Rodriguez et al., 2006). They utilized simple and panel regressions to examine the effect of corruption (Cuervo-Cazurra, 2006, 2008; Boubakri et al., 2013; Jiménez, 2010, Jiménez, 2011; Sanyal, 2005). Finally, they adopted the document analysis approach to critically examine, discuss or comment on the impact of laws on corruption in international business (Kaikati et al., 2000; Kaptein, 2004; Pacini et al., 2002).

# 4.2.4. Data sources and measurement of corruption

Table 6 illustrates that 36 articles used a corruption index, which is a country-level variable, to measure corruption in international business. Of these 36 articles, 22 used the indexes of Transparency International, 9 used World Governance indicators, and 5 used The International Country Risk Guide as a proxy for corruption in international business. Very few researchers used the corruption indexes of Germany exporters (Hung et al., 2018), the GLOBAL survey (Mazar & Aggarwal, 2011), or the World Competitiveness Yearbook (Pajunen, 2008). Furthermore, Tuliao and Chen (2017) and Yim et al. (2017) used bribery surveys of firms from the World Bank as a proxy for corruption. Six articles utilized questionnaires or interviews to measure corruption at the firm level (Gao, 2011; Luo, 2006; Muethel et al., 2011; Petrou, 2015; Roy & Oliver, 2009; Zhu, 2017).

# 4.2.5. Theoretical underpinnings

Table 7 illustrates that we identified several theoretical frameworks in the literature. Of the 137 papers, only 39 $( 2 9 ~ \% )$ examined and discussed any management theory. Of these 39 papers, 17 used institutional theory, 5 applied agency theory, and 3 papers examined the neo-institutional theory. The use of institutional theory is logical because researchers consider corruption a proxy for institutional quality at the country level. Furthermore, only a few papers used the resourcebased view, transaction cost theory, or the resource dependence theory. Other theories that appeared referred to structuration (Luo, 2006), socialization (Muethel et al., 2011), diversification and portfolios (Jiménez, 2010), stakeholders (Roy & Goll, 2014), property rights (Driffield, Mickiewicz, & Temouri, 2016), self-selection (Gomes et al., 2018), anomie theory (Chen et al., 2015), and legitimacy theory (Blanc, Cho, Sopt, & Branco, 2019). Most papers did not specifically mention the theoretical framework the authors utilized. They may have failed to do so because corruption is a country-level indicator, and the measurement of corruption at the firm level is quite difficult and un-standardized. We also discuss the key theories in the literature in the next section.

4.2.5.1. Institutional theory. The institutional theory deals with regulatory structures, government laws and regulations, courts, and professions (Oliver, 1991). These institutions establish the social, political, and legal norms that affect decision-making and actions (Meyer & Rowan, 1977). The institutional theory posits that there is social and legal pressure on firms to adopt the beliefs, values, and norms of their environment (Roy & Goll, 2014).

This theory also predicts the firm’s behavior. The institutional framework affects the strategies of firms and grants them legitimacy (North, 1990; Scott, 1995). The power of the host country’s institutional environment in terms of its control of corruption and the rule of law shapes and affects the firms’ entry strategy (Uhlenbruck et al., 2006), decisions about engaging in international joint ventures (IJVs) (Roy & Oliver, 2009), the composition of the board of these joint ventures (Hearn, 2015), the appointment of national managers (Muellner, Klopf, & Nell, 2017), and bribery behavior (Baughn et al., 2010; Yi, Teng, & Meng, 2017) in cross-national transactions. The institutional environment of host and home countries, of which the level of corruption is one factor, affects a firm’s export performance (Krammer, Strange, & Lashitew, 2018), management of earnings (Lewellyn & Rosey, 2017), merger and acquisition activities (Tunyi & Ntim, 2016), and location of foreign direct investment (Dikova, Panibratov, Veselova, & Ermolaeva, 2016).

Furthermore, the institutional theory raises concerns about how a corrupt institutional environment influences corporate social responsibility (Keig et al., 2015), profitability (Lee & Hong, 2012), values (Pantzalis et al., 2008), organizational legitimacy and strategic decision making (Rodriguez et al., 2005). This theory holds that the quality of institutions defines the level of corruption in the host and home country, which influences the nations and firms. The literature suggests that by improving the quality of institutions, the adverse effects of corruption can be minimized in international business.

<html><body><table><tr><td>Author(s)/Global Citations*</td><td>Purpose</td><td>Sample</td><td>Dependent Variables</td><td>Independent Variables</td><td>Findings</td></tr><tr><td>Tsalikis and Latour (1995)/29</td><td>-How does culture perceive bribery and extortion? -What is the effect of Greek and US culture</td><td>- 240 American and Greek business students</td><td>-Perceived bribery and extortion</td><td>-Culture variables</td><td>-Greeks receive and offer bribery mor Americans. -Greek culture impacts more perceivec</td></tr><tr><td>Zhu (2017)/11</td><td>on bribery and extortion? -What is the effect of MNEs&#x27;activity on the level of corruption in developing countries?</td><td>-Case study of China</td><td>-Corruption</td><td>-MNEs&#x27; activity</td><td>bribery and extortion. -MNCs&#x27;activities contribute to rent cr in developing countries,which leads t level of corruption. -In China,the provinces with more M</td></tr><tr><td>Sanyal and Guvenli (2009)/12</td><td>-What is the effect of national culture on a firm&#x27;s propensity to bribe?</td><td>-30 countries -Period: 2006</td><td>-Bribe payers&#x27;index</td><td>-Cultural variables</td><td>activities are strongly associated with corruption. -Firms from countries low on power d or long-term orientation,or high on individualism,are less likelytogag bribe giving,but economic developme impacts this relationship.</td></tr><tr><td>Chen et al. (2010)/ 59</td><td>-What is the impact of political connections-114 firms in 17 countries and corruption of firms on earnings forecasts?</td><td>-Period: 1997 to 2001</td><td>-Forecast accuracy</td><td>-Political connection, corruption</td><td>likely to give bribes. -Analysts experience greater diiculty predicting the earnings forecasts of po connected firms. -Where thecorruption levelis high,p</td></tr><tr><td>Muethel et al. (2011)/11</td><td>-Employees&#x27;prosocial values increase the firm&#x27;s performance,and corporate corruption is an impediment. -Corporate corruption negatively affects</td><td>-19,026 individuals from 17 countries -Cross-country level analysis</td><td>-Employees&#x27;prosocial values</td><td>-Transformational leadership,professional altruism,corporate corruption</td><td>connections impact more earnings for -National business ideology has a posi impact on employee&#x27;s prosocial values -National business ideology does not a the control of corporate corruption be employees use rationalization strategi</td></tr><tr><td>Keig et al. (2015)/ 29</td><td>-What is the effect of formal and informal corruption environment on multinational enterprises&#x27;social irresponsibility (CSR)?</td><td>2010 KLD social responsibilityauthors&#x27;calculation) rating dataset.</td><td>-Seven hundred firms from the-Corporate social irresponsibility (KLD,</td><td>-Formal Corruption Environment (FCE), Informal Corruption Environments (ICE)</td><td>against corruption. -MNEs&#x27;corruption environment is con of both a formal and informal dimensi -MNEs&#x27;portfolio of locations is charac by higher levels of formal and informa corruption and is associated with high</td></tr><tr><td>Sanyal (2005)/66</td><td>-What is the effect of economic and cultural-50 countries variables on the level of corruption and bribe-taking in international business?</td><td></td><td>-Corruption perception index</td><td>-Economic variables,foreign trade,income distribution,cultural variables (power distance,individualism,masculinity,</td><td>levels of CSR. -Bribe taking is conventional in count with low per capita income and small disparities in income distribution. -The bribe is also associated with high</td></tr><tr><td>Tunyi and Ntim (2016)/11</td><td>-Effect of the firm- and country-specific antecedents of African M&amp;As activities. -Location advantage and market development effect on M&amp; A. -National governance quality effect on M &amp; As.</td><td>-1490 African firms from 15 countries -Period: 1996 to 2012</td><td>-M&amp;A volume</td><td>-Country-level determinants; (see Table A1),national governance: measured through corruption (TI),Firm-level determinants (see Table A2)</td><td>distance and high masculinity in the c -Location advantages (market size, hu capital,and efficiency opportunities) positive effect on M&amp; A volume. -High quality national govermance (le corruption) also has a positive effect. -Market development is positivelyrel</td></tr><tr><td>Jensen et al. (2010)/42</td><td>-Firm-level survey data, nonresponse,and false response bias related to issues of corruption in international business examined.</td><td>-44,000 firms in 72 countries-Corruption Period: 2000 to 2005</td><td></td><td>-Press freedom (non-response and false response),Political freedom.</td><td>M &amp; A volume. -Firms that belong to countries with le freedom used non-response and false r options during surveys on corruption. -Ignorance of these firms&#x27;responses le</td></tr></table></body></html>

<html><body><table><tr><td>Author(s)/Global Citations*</td><td>Purpose</td><td>Sample</td><td>Dependent Variables</td><td>Independent Variables</td><td>Findings</td></tr><tr><td>(2012)/12 Lee and Hong</td><td>-What is the impact of the level of corruption on MNCs’profitability?</td><td>-MNC subsidiaries</td><td>-US MNC in Asia Pacific Region-Subsidiaries&#x27;profitability</td><td>-Level of corruption in the host country and at home,Local Sales Ratio (LOCAL)</td><td>-MNC subsidiaries located in countries with a lower level of corruption are more profitable than those in corrupt countries. -MNC subsidiaries with a greater focus on local sales are more profitable than</td></tr><tr><td>Boubakri et al. (2013)/43</td><td>-The effect of political institutions and political connections of the firms on their risk-taking.</td><td>- 26,513 non-financial firms from 77 countries -Period: 1988 to 2008</td><td>-Risk-taking variables</td><td>-Political constraints index,political connections,corruption,other country-level variables (see Table A1)</td><td>international sales-focused ones when the corruption level is low at home. -Political institutions affect corporate risk- taking; however,this relationship strength when govt. extraction is higher. -Politically connected firms engage in more -To increase corporate investment, the risk-taking.</td></tr><tr><td>Jiménez, 2010/37</td><td>-Effect of institutions on international diversification. -Relationship between political risk and the scope of internationalization. -Effect of corruption (political risk measured through corruption) on internationalization.</td><td>119 countries</td><td>-166 Spanish firms with FDI--Firm&#x27;s internationalization</td><td>-Political risk measured through three indexes: economic freedom, corruption perception index,political constraint index</td><td>government should control corruption. -Spanish firms partially follow the Uppsala model. Political capabilities play a crucial role in the internationalization strategy. -Firms rely on the corrupt host country in the short and long terms. -Political risk and corruption hurt</td></tr><tr><td>Kaczmarek and Newman (2011)/24</td><td>-What is the effect of US extraterritoriality-29 OECD members and national policy oncombating corruption globally?</td><td>-Period: 1998 to 2008</td><td>-Significant enforcer of bribe cases</td><td>-US enforcement (FCPA 1977 law enforcement),international integration: trade openness,outward FDI, total countriescorruption.Likely to enforce their national enforcement, peer review</td><td>internationalization. -US extraterritoriality and national policy are twenty times more effective in combating rules. -Domestic laws have an essential influence.</td></tr><tr><td>Cuervo-Cazurra (2006)/ 196</td><td>-Impact of corruption at foreign direct investment (FDI).</td><td>-Home countries 186 -Host countries 106</td><td>-Bilateral FDI inflows</td><td>-Host-country corruption,host country with laws against bribery,the home country with high corruption</td><td>-Corruption results in less FDI from countries that signed the OECD Convention on combating bribery. Corruption results in more FDI from countries having a high level of corruption.</td></tr><tr><td>Driffield et al. (2013)/25</td><td>-Effect of a conflict zone on FDI. -Conflict zones are identified based on the level of corruption.</td><td>- 2,509 firms -Period between; 1997 to 2009</td><td>-Conflict zone (level of corruption)</td><td>-Profitability,numberof subsidiaries,firm&#x27;s age,ownership,industry,the home country of MNEs dummy</td><td>-Identified MNEs investing in low-income countries with weak institutions. -MNEs from weaker institutions (high level of corruption) and fewer concerns about CSR invest in conflict zones. -Firms with concentrated ownership invest in</td></tr><tr><td>Perez et al. (2012)/ 18</td><td>-How do illicit money flows influence the volume of FDI to countries that are centers of money laundering,and what is the role of host and home country corruption?</td><td>-83 host countries</td><td>-FDI location choice</td><td>-Corruption,culture, money laundering status of the country,governance measures</td><td>conflict zones. -The traditional model of FDI does not work in highly corrupt countries.</td></tr><tr><td>Brockman et al. (2013)/29</td><td>-The effect of institutional environments on the performance of mergers &amp; acquisition (M&amp;A) of politically connected firms.</td><td>-Politically 168 firms and 509 deals from 22 countries</td><td>-M &amp; A performance,post M &amp; A</td><td>-Country-level institutional variables; the level of corruption, weakness of the legal system</td><td>-Political connections play an economically significant role in post-mergers. -The nature of the effect depends on institutional settings.</td></tr></table></body></html>

<html><body><table><tr><td>Author(s)/Global Citations*</td><td>Purpose</td><td> Sample</td><td>Dependent Variables</td><td>Independent Variables</td><td>Findings</td></tr><tr><td>Pajunen (2008)/89</td><td>-What is the effect of institutions on FDI? -Corruption is an institutional factor.</td><td>-Host countries 47 -Period: 1999 to 2003</td><td>-FDI attractiveness and unattractiveness of country; Fuzzy-set index</td><td>-Institutional factors (sets),non-t flexible labor regulations, just judicial system,political rights and civil liberties, favorable taxation,political stability, property rights</td><td>-Institutional factors have varying influence, and a combination of institutional factors affects FDI in countries. -There are several paths to confirming the effect of institutional factors on FDI. -Corruption and property rights affect FDI ir</td></tr><tr><td>Franke and Richey (2010))/41</td><td>-There are generalizations issues in findings from a small number of countries as a sample in international business. -The confirmation of the effect of</td><td>-Cross-cultural studies in international business between 1995 and 2005</td><td>-Economic development</td><td>-Level of corruption</td><td>all combinations. -7-10 countries may support generalization in international business but include large samples. Corruption hurts economic development.</td></tr><tr><td>Jiménez, 2011/12</td><td>economic development of a country. -Effect of political risk and corruption on FDI inflows to African and Central Eastern Europe.</td><td>-FDI from Spain,France,and Italy -To North African and CEE countries -Period: 1999 to 2006</td><td>-Outflows of FDI</td><td>-Corruption,Political ConstraintIdex, Index of Economic Freedom.</td><td>-Greater levels of political risk,measured through scales of political discretion, corruption,and economic freedom,attract larger inflows. -As a consequence of political risk, the inflov should fall, but it increases because the firms are searching for a market niche where they</td></tr><tr><td>Meschi (2009)/17</td><td>-What is the effect of government corruption on the equity stake of foreign partners in international joint ventures (IJV) formed with local firms?</td><td>-Firms in emerging Asian countries -171 European firms -Period: 1996 to 2007</td><td>-European firms’partners’stake in IJV- IJV survival/termination varible (Dummy)</td><td>-Level of government corruption</td><td>capabilities. -Government corruption is significantly related to the likelihood offoreign partners terminating the IJV. -However,the country&#x27;s experienceof foreigi partners moderates the relationship between government corruption and foreign partners</td></tr><tr><td>Cuervo-Cazurra (2008)/70</td><td>-What is the effect of laws against combating bribery and corruption?</td><td>-Host-countries 106 -Period: 1996 to 2002</td><td>-Bilateral FDI inflows</td><td>-Investor-host-country implemented OECD anti-briberyonvention,Ivestorome country is the US,the investor-home country is the US before 1998,the investor- home country is the US after 1998,host-</td><td>in IJVs. -Laws should be implemented in multiple countries collectively because investors bypass thelaws when others are not followin them. -Countries that signed the OECD convention combating bribery and US investors invest</td></tr><tr><td>Heam (2015)/13</td><td>-Effect of institutions on the board composition of an international joint venture (IJV) in emerging markets. -Control of corruption represents the institutions.</td><td>-200 IPOs in African countries-Likelihood of IPO firm being an IJV -Period: January 2000 to January 2004</td><td></td><td>-Ratio of social elites to military ratio,ratio of social elites to government,ratio socialof elites to commerce,ratio of social elites to university,interactive variables (see Table 3),institutional enviroent, institutional quality, control of corruption.</td><td>less in corrupt countries. -Social and political legitimacy concerns dominate the external role of boards. -Governmental elites are associated with country-level improvements in corruption control and political stability. -Business elites are only marginally associatec with improvements in political stability,</td></tr><tr><td>Baughn et al. (2010)/32</td><td>-What are the determinants of a firm&#x27;s bribery in international business? -Which domestic and international factors lead to the firm&#x27;s bribery abroad?</td><td>-30 countries</td><td>-2006 bribe payer&#x27;s index</td><td>-Level of corruption in each country, OECD convention acceptance by countries, patterns of trade,exports to OECD countries,imports from OECD,overall trade</td><td>regulatory quality,the rule of law,and democratic voice and accountability measure -Firms from countries that are signatories of the OECD anti-bribery convention do not bribe due to the low level of corruption at home while controlling for economic and cultural variables.</td></tr></table></body></html>

<html><body><table><tr><td>Author(s)/Global Citations*</td><td>Purpose</td><td>Sample</td><td>Dependent Variables</td><td>Independent Variables</td><td>Findings developed countries have a greater</td></tr><tr><td>Pantzalis et al. (2008)/12</td><td>-What is the impact of country-level corruption on US MNCs&#x27; value?</td><td>-528 MNCs from the US -Period: 1995-1998</td><td>-Level of corruption</td><td>-Tobin-q, Adjusted Tobin-q,Excess value</td><td>propensity to bribe. -Country-level corruption has a multi- dimensional impact on MNCs&#x27; valuation. -Intangible assets (IPRs) have less impact on MNCs&#x27;value in corrupt countries due to less protection of IPRs. -MNCs&#x27;expansion in corrupt countries negatively impacts their value. -Geographic diversification in corrupt countries significantly increases the firm&#x27;s value if the MNC has high levels of intangibles,such as technological know-how</td></tr><tr><td>Uhlenbruck et al. (2006)/150</td><td>-What is the effect of corruption on the entry mode strategy of MNEs in emerging economies? -How do firms adjust their strategy for entering foreign markets in corrupt environments? -Howdodifeenttypsofcorrufect firms&#x27;choices?</td><td>- 220 telecommunications development projects in 64 emerging economies -Period: 1996-1998</td><td>-Entry mode of MNEs</td><td>-Pervasiveness and arbitrariness of corruption, and CPI</td><td>and marketing expertise. -MNEs willrespond to pervasive and arbitrary corruption in a host country by selecting particular types of equity and non-equity modes of entry. -Firms adapt to the pressures of corruption via short-term contracting and entry into joint ventures. -Arbitrariness surrounding fraudulent transactions has a significant impact on firms&#x27; decisions. -MNEs use non-equity-entry modes or partnering as an adaptive strategy to participate in markets despite the presence of</td></tr><tr><td>Mazar and Aggarwal (2011)/58</td><td>-What is the effect of national culture on the-62 countries propensity to bribe in international business partners? -Why are there national differences related to the propensity to bribe?</td><td></td><td>-Level of corruption</td><td>-National culture</td><td>corruption. -A significant effect of the degree of colectivism versus individualismpresent ina national culture on the propensity to offer bribes to international business partners. -The effect was mediated by individuals&#x27; sense of responsibility for their actions. -Together,these results suggest that collectivism promotes bribery through less</td></tr><tr><td>Brada e al. (2012)/ 17</td><td>-Effect ofhome and host country corruption on FDI.</td><td>-84 host countries -Period: 2000-2003</td><td>-FDI outflow</td><td>-Home country corruption, -Host country corruption.</td><td>perceived responsibility for one&#x27;s actions. -The modelseparates theeffects of corruption on FDI location decisions and the amount</td></tr></table></body></html>

4.2.5.2. Neo-institutional theory. Neo-institutional theory reflects the sociological view of institutions. It suggests that isomorphism, which is a process that forces one unit to resemble other units in the population because they face the same set of environments, plays a role in corruption (Hawley, 1968). Isomorphism consists of three mechanisms: coercive, mimetic, and normative (DiMaggio & Powell, 1983). Currently, the neo-institutional perspective is quite popular in the organizational field and international business. It maintains that firms respond to the cognitive, normative, and regulatory pressures on other firms that are considered legitimate (DiMaggio & Powell, 1983). Gao (2010) uses the neo-institutional framework to examine the effect of mimetic isomorphism on bribery by firms working in China. He confirms that the firms’ bribery behavior reflects the habits of other companies in China. This theory explains the firms’ choice about when to engage in corrupt practices themselves and when their subsidiaries do so as well (Lambsdorff, 2013). Cuervo-Cazurra (2016) also recommends extending the neo-institutional theory by considering corruption as a laboratory.

4.2.5.3. Agency theory . Jensen and Meckling (1976) developed agency theory, which maintains that managers try to divert corporate resources to maximize private benefits at the cost of shareholders because incentives are lacking. Agency theory explains that this behavior creates investment risks and produces the agency problem in international business. In addition to agency problems, Stulz (2005) argues that there is a potential link between political institutions and the managers’ choice of investment risks. Political institutions are managed by governments, which play an important role in the firm managers’ decision making through the strict rule of law, overregulation, and level of corruption. Political institutions and the level of corruption affect corporate risk-taking decisions, and politically connected firms take more risks, which leads to agency problems (Boubakri et al., 2013). This theory explains the potential conflict between the firm’s headquarters and its foreign subsidiaries in cases of offering bribes due to political connections (Yi et al., 2017). Firms have two options: lobbying or bribery in the host country. The effect of lobbying in the host country is more positive than offering bribes (Yi et al., 2017). Agency theory suggests that manager-controlled firms offer more bribes than shareholder-controlled firms due to conflicting goals, a theory that Chen et al. (2015) confirmed empirically. There are associations between bribery and the corrupt behavior of firms and the characteristics of boards of governance such as CEO duality (Das-Gupta & Wu, 2008), manager, or shareholder-controlled firms (Chen et al., 2015), and gender (Tuliao & Chen, 2017). Studies have also used agency theory to analyze corruption at the country level.

<html><body><table><tr><td>Author(s)/Global Citations*</td><td>Purpose</td><td>Sample</td><td>Dependent Variables</td><td>Independent Variables</td><td>Findings</td></tr><tr><td>Roy and Oliver (2009)/49</td><td>-What is the effect of the host-country legal environment (control of corruption and the rule of law) on international joint ventures (IJVs)？</td><td>-11 corporate executives involved in 169 IJVs -Canadian MNEs</td><td>-Partner selection criteria,partner-related criteria,task-related criteria, appropriation concerns, coordination cost concerns.</td><td>-Host country&#x27;s legal environment,control of corruption,the rule of law</td><td>100,etal. -The legal and institutional environment of the country- control of corruption and the rule of law are significant factors for Canadian MNEs in selecting a partner for</td></tr><tr><td>Luo (2006)/ 98</td><td>-Evaluate the way MNEs manage political and social forces in emerging markets. Combine three lenses: political behavior, corporate social responsibility (CSR),and corruption.</td><td></td><td>-126 MNEs operating in China-Politics (assertiveness,cooperativeness social,connections,arm&#x27;s-length bargaining), CSR (ethical codes,org. credibility,philanthropic contribution)</td><td>-Perceived corruption</td><td>IJVs. -If perceived corruption is high,MNEs with higher CSR use arm&#x27;s length bargaining. Moreover,MNEs with lower CSR use social connections to deal with govemments.</td></tr></table></body></html>

4.2.5.4. Other theories. The resource-based view explores how a firm can create resources distinct from those of its competitors to satisfy customers or how firms can use competitive and institutional resources when operating aboard (Cuervo-Cazurra, 2016). Hillman (2005) argues that firms can create relationships with foreign government officials or politicians as their resource and can use them instead of bribes. Yim et al. (2017) confirm that lobbying adds more value to a firm than bribery.

The transaction cost theory provides details of a firm’s behavior based on the cost of its economic transactions. Bribery and corruption are viewed as an additional cost of operating nationally and internationally because they result in uncertainty in the relationship between the firm and the government (Cuervo-Cazurra, 2016). Meschi (2009) examines the effect of corruption on international joint ventures through the transaction cost theory perspective. He documents that corruption adds more costs to such ventures, but the experience of foreign partners in the country moderates this relationship.

<html><body><table><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td>ZI/(7 I11) 14111</td></tr><tr><td>/</td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td></table></body></html>

<html><body><table><tr><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td><td rowspan="9"></td></tr><tr><td></td></tr><tr><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td></td><td></td></tr><tr><td>CSS</td><td></td></tr><tr><td></td><td></td></tr></table></body></html>

<html><body><table><tr><td></td><td>SSS /tz) z gre </td><td></td><td></td><td></td><td></td></tr></table></body></html>

<html><body><table><tr><td>Author (s)/Global Citations*</td><td>Models/Methods</td><td>RQs/Purpose</td><td>Findings</td></tr><tr><td rowspan="3">Galang (2012)/30</td><td rowspan="3">-Content analysis -Discussion of international business-specific issues with corruption.</td><td>-What is the relationship between government</td><td>-Empirical work confirms the findings of a corrosive impac government corruption on firm performance in general and</td></tr><tr><td>corruption and firm performance?</td><td>management research. -Proposes an integrative model of a firm&#x27;s strategy vis-a-vis corruption predicting that the firm will choose its approach</td></tr><tr><td></td><td>based on its organizational structure,political resources, industry regulation,and surrounding political and social</td></tr><tr><td rowspan="2">Doh et al. (2003)/104</td><td rowspan="2">-Contextual analysis -Content analysis</td><td rowspan="2">-How do MNEs respond to corruption when investing in foreign markets in developing countries?</td><td>institutions. -Presents an overview of the direct and indirect costs of corruption and how it impacts MNEs.</td></tr><tr><td>-Presents a framework that incorporates two basic dimension government corruption: pervasiveness and arbitrariness. Proposes five broad strategies that multinationals should consider in responding to corruption and gives examples of</td></tr></table></body></html>

Resource dependence theory provides a benchmark to explain the power relationship between two parties in which one party can exercise power over the other (Pfeffer & Salancik, 1978). One study utilizes this theory to analyze how firm managers in host countries gain the support of government officials by providing them with bribes because a foreign company has less power than local firms (Cuervo-Cazurra, 2016). Petrou (2015) uses the resource dependence viewpoint to document that the arbitrariness of corruption in a host country has a negative impact on a subsidiary’s performance.

The greatest limitation of most of the theories used to investigate corruption in international business is the lack of clarity in explaining the multidisciplinary and complex dynamics of corruption at the country and firm levels. Therefore, we call for the extension of these theories by considering corruption as a major factor.

# 5. A synthesis of corruption in international business

In the 1990s, corruption emerged as one of the most serious global political issues affecting international business (Mijares, 2015). To this day, corruption and bribery remain persistent and perplexing problems in investment and trading (Nichols, 2012). Therefore, one of the central questions is: what are the antecedents and consequences of corruption in international business? Fig. 4 illustrates our synthesis of the literature that we used to explore the answer to this question. We utilized our seven identified research streams to synthesize the antecedents and consequences of corruption in the international business literature.

# 5.1. Country (macro)level antecedents: Host and home country

Country-level antecedents play a crucial role as determinants of corruption in home and host countries. The key factors identified in research stream one (legislation against corruption in international business) are the lack of international laws (Everett et al., 2006 ; Nichols, 2012) and non-enforcement of the OECD convention and FCPA in non-member countries (Kaikati et al., 2000 ; Klaw, 2012). Therefore, it is essential to increase the bilateral implementation of anti-corruption laws through groups such as the WTO and the World Bank (CuervoCazurra, 2008).

In research stream two, scholars identified three factors that influence corruption: economic factors (Chen et al., 2015; Lopatta, Jaeschke, Tchikov, & Lodhia, 2017; Sanyal & Samanta, 2017; Sanyal, 2005), cultural factors (Roy & Goll, 2014), and other factors (Gao, 2011 ; Sanyal & Samanta, 2017). Sanyal and Guvenli (2009) and Baughn et al. (2010) document the significant effect of economic and national cultural factors on the likelihood of individuals and firms to engage in bribery (see also Hofstede, 1980). Gelbrich, Stedham, and Gathke (2016) identify and resolve some discrepancies in the measurement of cultural factors and confirm them as determinants of corruption. Frei and Muethel (2017), Sanyal (2005), and Sanyal and Guvenli (2009) show that national cultural and economic factors lead to corrupt activities in both home and host countries.

# 5.2. Corruption

Country-level antecedents lead to a higher level of corruption. Corruption has two main causes: the demand side and the supply side (Everett et al., 2006). Corruption is also divided into several types, such as public (Pontell & Geis, 2007), private (Argandona, 2003), pervasive, and arbitrary (Rodriguez et al., 2005). Public corruption is further divided into four subtypes: petty and grand (Elliott, 1997) and organized and unorganized (Shleifer & Vishny, 1993). Analysts and researchers measure corruption through structured interviews, surveys, and indexes such as those of the World Bank and Transparency International.

# 5.2.1. Controlling for firm-level antecedents

Scholars have explored the country-level antecedents of the firmlevel consequences of corruption by controlling for firm-level antecedents (see Fig. 4). Their goal is to determine how corruption impacts the firm, which is the main subject of discussion in international business. Therefore, the scholars control for multiple firm-level factors such as size, age, sales, volume, asset growth, industry, international experience, ownership, loss frequency, leverage, length of operating cycle, earnings volatility, profitability, and number of subsidiaries (Chen et al., 2010; Driffield et al., 2013; Hung et al., 2018; Luo, 2006; Roy & Oliver, 2009).

# 5.2.2. Extending the concepts of corruption

Cuervo-Cazurra (2016) proposes extending the five important firm theories—agency, transaction cost economics, the resource-based view, resource dependence, and the neo-institutional theory—by considering corruption as a laboratory. Doh et al. (2003) also present a framework for multinational enterprises that deal with corruption in international business.

# 5.3. Firm-level consequences

As the fourth stream of research indicates, on the macro-level, corruption affects the key players in international business with regard to their earnings forecasts and management (Chen et al., 2010; Lewellyn & Rosey, 2017), firm disclosures (Hung et al., 2018), risktaking (Boubakri et al., 2013), corporate social responsibility (Luo, 2006), international joint ventures (Hearn, 2015; Meschi, 2009; Roy & Oliver, 2009), organizational legitimacy and decision making (Rodriguez et al., 2005), the prosocial values of the firm (Muethel et al., 2011), export performance (Krammer et al., 2018), the performance of foreign affiliates and subsidiaries (Muellner et al., 2017; Petrou, 2015), foreign affiliates’ ownership (Driffield et al., 2016), the firms’ volume of activities and performance (Geleilate, Magnusson, Parente, & AlvaradoVargas, 2016; Lee & Hong, 2012; Tunyi & Ntim, 2016), social irresponsibility (CSR) (Keig et al., 2015), entry mode strategy (Uhlenbruck et al., 2006), SMEs’ performance (Kouznetsov, Dass, & Schmidt, 2014), and the performance of mergers and acquisitions (M&A) (Brockman et al., 2013).

# 5.3.1. Firm-level consequences: politics and corruption

As the fifth stream of research indicates, there is a connection between the political environment and corruption in international business. Luo (2006) argues that in very corrupt host countries, politically connected firms with few ethics engage in bribery. Similarly, politically connected firms reflect the weak performance of mergers and acquisitions (M&A), where the level of corruption is low in the host country. Politically connected firms in corrupt countries also issue fewer earnings forecasts (Hung et al., 2018). In contrast, Yim et al. (2017) maintain that political connections are suitable for firms because lobbying has a more positive effect than bribes.

# 5.4. Combating corruption

In the second research stream that explored combatting corruption in international business, scholars determined that corruption is an irregular tax and additional cost borne by society (Mauro, 1995; Shleifer & Vishny, 1993). The IMF, OECD, UN, World Bank, EU, WTO, and Transparency International all play a key role in combating corruption. The 1997 conventions of the UN, OECD, and EU are major guidelines for the formation of national laws and regulations against corruption (Gantz, 1998). The implementation of the US Foreign Corrupt Practices Act of 1977 and the OECD anti-bribery convention (Cuervo-Cazurra, 2008) is essential to overcome the issue of corruption in business transactions. Rose-Ackerman (2002) and Kaptein (2004) suggest that firms should establish ethical standards and business codes against corruption.

# 6. Research agenda

The literature on corruption in international business is maturing rapidly and covers multiple research areas. Nevertheless, there are still aspects of corruption in international business that are essential to explore. To provide recommendations for the future research agenda, we utilized a four-step methodology. First, we identified 79 influential articles through bibliometric citation analysis. Second, we analyzed the content of these influential articles through content analysis to determine a future research agenda. Third, we converted the potential research agenda into research questions and propositions. Finally, we verified and excluded identified research questions that scholars have already addressed. The procedure resulted in 14 future research questions (see Table 8), and 6 gaps in our knowledge and propositions for addressing them.

# 6.1. Future research questions

# 6.1.1. Legislation against corruption in international business

This research stream builds on the papers about the EU, FCPA, and OECD conventions to formulate international and national laws against corruption in international business. Therefore, it is essential to explore the real effects of these conventions on corruption in bribe-demanding and bribe-supplying countries (Darrough, 2010). Furthermore, the scope of the analysis of anti-corruption legislation needs to be broadened to the country level to ascertain the role of national laws such as the 1999 Australian Criminal Act and the 1998 Canadian Corruption of Foreign Public Officials Act in combatting corruption in the host and home countries (Mijares, 2015; Pedigo & Marshall, 2009).

# 6.1.2. The determinants of corruption in international business

In this stream, the research focuses on the economic (Roy & Goll, 2014; Sanyal & Guvenli, 2009) and cultural factors (Armstrong, 1992; Tsalikis & Latour, 1995) that affect the level of corruption in international business. However, these factors are multi-faceted. Therefore, we must examine their link with the sustainability indicators of a country (including the avoidance of corruption) (Roy & Goll, 2014). Gender also affects a firm’s behavior about bribery, but it is interesting to explore the role of gender in CEO-plurality firms (Tuliao & Chen, 2017). The existence of a prior colonial relationship (for example, between the

Table 5 Key methods used in the literature on corruption in IB.   

<html><body><table><tr><td>Type</td><td>Method</td><td>No. of articlesa</td><td>References</td></tr><tr><td>Qualitative Analysis</td><td>Content Analysis</td><td>35</td><td>Rodriguez et al., 2006; Kaptein, 2004; Everett et al.,2006; Krueger,2009; Blanc et al.,2019; Cuervo- Cazurra,2016; Xie et al.,2017; Weber &amp; Getz, 2004; Windsor,2004; Galang, 2012; Celentani et al., 2004; Frei&amp; Muethel,2017; Nichols,2012; Foster,2015; Doh etal.,2003; Marat,2015; Funk, Trevino,&amp; Funk, 2017; Maria, 2010; Lord &amp; Levi, 2017; Lambsdorf, 2013; Hefendehl, 2010; Fard &amp; Hassanpour, 2016; Hotchkiss1998; Mijares,2015; Armstrong,1992; Pedigo &amp; Marshall,2009; Cleveland etal.,2009;</td></tr><tr><td></td><td>Document Analysis</td><td>12</td><td>et al.,2008; Kaptein, 2004; Horak, 2018. Kaikati et al.,2000; Pacini etal.,2002; Kaptein, 2004; Everett et al.,2006; Argandona, 2003; Nichols,</td></tr><tr><td></td><td>Contextual Analysis</td><td></td><td>2012; George et al.,1998; Foster,2015; Wenhao &amp; Ahmad,201; Klaw,2012; Laudone,2016; Spalding, 2011.</td></tr><tr><td></td><td>Case Study</td><td>5 2</td><td>Czinkota &amp; Skuba, 2014; Keig et al., 2015; Rodriguez et al., 2005; Doh et al., 2003. Blanc et al., 2019; Lambsdorff, 2013; Guo et al., 2018</td></tr><tr><td>Quantitative Analysis</td><td>Regression (OLS)</td><td>20</td><td>Jensen et al.,2010; Chen et al.,2010; Hung et al.,2018; Sanyal,2005; Peng &amp; Beamish,2008; Baughn et al.,2010; Jiménez,2010; Roy &amp; Goll,2014; Driffeld etal.,2013; Gelbrich et al.,2016; Muellner et al.</td></tr><tr><td></td><td>Panel Regression</td><td>17</td><td>2017; Meschi, 2009; Lee &amp; Hong, 2012; Rose-Ackerman, 2002; Mazar &amp; Aggarwal, 201l; Zhu, 2017; Gao, 2011; Sanyal &amp; Guvenli, 2009; Oesterle &amp; Bjorn, 2017. Boubakri et al., 2013; Brockman et al., 2013; Hung et al., 2018; Peng &amp; Beamish, 2008; Drifield et al., 2013; Pantzalis et al., 2008; Uhlenbruck et al., 2006; Mornah &amp; Macdermot, 2018; Sambharya &amp;</td></tr><tr><td></td><td></td><td></td><td>Rasheed,2015; Jiménez, 2011; Lopatta et al.,2017; Mukherjee,2018; Dikova etal.,2016; Kaczmarek &amp; Newman, 201l; Sanyal &amp; Samanta, 2017; Yim et al., 2017; Cuervo-Cazurra, 2006, 2008. Hung et al.,2018; Drifield etal.,2013; Krammer etal.,2018; Perez et al.,2012; He etal.,2015; Brada</td></tr><tr><td></td><td>Probit Model</td><td>07</td><td>et al., 2012. Hearn, 2015.</td></tr><tr><td></td><td>Logistic regression Multinomial Logit</td><td>1 3</td><td>Drifield et al.,2016; Tunyi &amp; Ntim,2016; Gomes et al.,2018; Jiménez, Marcelus,Guoliang,&amp; Jiang,</td></tr><tr><td></td><td>Regressions</td><td></td><td>2017</td></tr><tr><td></td><td>Binomial Regression Tobit Model</td><td>1</td><td>Keig et al., 2015 He et al., 2015</td></tr><tr><td></td><td>Hierarchical Regression</td><td>1 7</td><td>Roy &amp; Goll,2014; Petrou,2015; Lewelyn &amp; Rosey,2017; Chen et al., 2015; Muethel et al., 2011;</td></tr><tr><td></td><td>Analysis Structural Equation</td><td></td><td>Lewellyn &amp; Rosey, 2017; Tuliao &amp; Chen, 2017 Luo, 2006; Roy &amp; Oliver, 2009</td></tr><tr><td></td><td>Modeling</td><td>2</td><td></td></tr><tr><td></td><td>Fuzzy-set Analysis</td><td>1</td><td>Pajunen, 2008</td></tr><tr><td></td><td>Bayesian Analysis</td><td>1 1</td><td>Franke &amp; Richey, 2010/41 Brockman et al., 2013</td></tr><tr><td></td><td>Propensity Score Matching</td><td>1</td><td>Tsalikis &amp; Latour, 1995</td></tr><tr><td></td><td>ANOVA</td><td>1</td><td>Wu &amp; Huang, 2013</td></tr><tr><td></td><td>ANCOVA</td><td></td><td>Huang, Liu, Zheng, Tan,&amp; Zhao, 2015</td></tr><tr><td></td><td>MANOVA</td><td></td><td></td></tr><tr><td></td><td>Meta-Analysis</td><td></td><td>Geleilate et al., 2016</td></tr><tr><td></td><td>Delphi Method</td><td>1</td><td>Czinkota &amp; Ronkainen, 2019</td></tr></table></body></html>

Note: The table lists the qualitative and quantitative methods researchers use to study corruption in international business. a Some papers utilize more than one method.

Table 6 Data sources and measurement of corruption in the literature.   

<html><body><table><tr><td>Measurement of Corruption</td><td>Date Source</td><td>Articles</td><td>Reference</td></tr><tr><td>Corruption Variable</td><td>Questionnaire/Interview/Survey</td><td>6</td><td>Luo, 2006; Roy &amp; Oliver, 2009; Muethel et al., 2011; Petrou, 2015; Zhu, 2017; Gao, 2011.</td></tr><tr><td>Corruption Perception Index</td><td>Transparency International</td><td>22</td><td>Cuervo-Cazurra, 2008; Franke &amp; Richey, 2010; Chen et al., 201O; Brockman et al., 2013; Sanyal, 2005; Peng &amp; Beamish, 2008; Roy &amp; Goll, 2014; Jiménez, 2010; Baughn et al., 2010; Gelbrich etal., 2016; Tunyi &amp; Ntim, 2016; Muellner et al., 2017; Keig et al., 2015; Meschi, 2009; Gomes et al., 2018; Uhlenbruck et al., 2006; Mornah &amp; Macdermot, 2018; Jiménez, 2011; Oesterle &amp; Bjorn, 2017;</td></tr><tr><td>Corruption Index</td><td>World Governance indicator</td><td>9</td><td>Kaczmarek &amp; Newman, 2011; Sanyal &amp; Samanta, 2017; Brada et al., 2012. Jensen et al., 2010; Muethel et al., 2011; Lewellyn &amp; Rosey, 2017; Tunyi &amp; Ntim, 2016; Keig et al.,2015; Lee&amp; Hong, 2012; Jiménez, Marcelus, Guoliang,&amp; Jiang,</td></tr><tr><td>Corruption Index</td><td>The International Country Risk Guide</td><td>5</td><td>2017; Mornah &amp; Macdermott, 2018; Cuervo-Cazurra, 2006. Boubakri et al.,2013; Driffield et al., 2013, 2016; Meschi, 2009; Mukherjee, 2018</td></tr><tr><td>Corruption Index</td><td>Corruption (German exporters index- Neumann, 1994)</td><td>1</td><td>Hung et al., 2018</td></tr><tr><td>Pervasiveness and Arbitrariness of Corruption</td><td>World Business Environment Survey</td><td>1</td><td>Uhlenbruck et al., 2006</td></tr><tr><td>Corruption Index</td><td>GLOBE-Survey</td><td>1</td><td>Mazar &amp; Aggarwal, 2011</td></tr><tr><td>Bribery Survey of Firms</td><td>Productivity and Investment Climate Survey (PICS) of the World Bank Group</td><td>1</td><td>Tuliao &amp; Chen, 2017</td></tr><tr><td>Bribery Survey of Firms</td><td>World Bank&#x27;s Enterprise Survey</td><td>1</td><td>Yim et al., 2017</td></tr><tr><td>Corruption Index</td><td>World Competitiveness Yearbook</td><td>1</td><td>Pajunen, 2008</td></tr></table></body></html>

Note: The table lists the data sources and measurements of corruption in the international business literature.

Table 7 Theories used in the literature on corruption in IB.   

<html><body><table><tr><td>Theory</td><td>Articles</td><td>References</td></tr><tr><td>Institutional Theory</td><td>17</td><td>Roy&amp;Oliver,2009;Baughetal,2010;Roy&amp;Goll,2014; Yietal,2017; Krammeretal.,2018; Hear,2015;ewellyn&amp;Rose 2017;Tunyi&amp;Nim,2016; Muelleretal,2017; Keigetal.,2015;Lee&amp;Hong,21;Rodriguezetal.,20; Ulenbucketal,</td></tr><tr><td>Agency Theory</td><td>5</td><td>2006; Oesterle &amp; Bjorn, 2017; Dikova et al., 2016; Pantzalis et al., 2008. Boubakri etal.,2013; Yi et al., 2017; Cuervo-Cazurra, 2016; Chen et al., 2015; Tuliao &amp; Chen, 2017.</td></tr><tr><td>New-Institutional Theory</td><td>3</td><td>Cuervo-Cazurra, 2016; Lambsdorff, 2013; Gao, 2011</td></tr><tr><td>Resource-Based View</td><td>2</td><td>Cuervo-Cazurra, 2016; Yim et al., 2017</td></tr><tr><td>Transaction Cost Theory</td><td>2</td><td>Cuervo-Cazurra, 2016; Meschi, 2009</td></tr><tr><td>Resource Dependence Theory</td><td>2</td><td>Petrou, 2015; Cuervo-Cazurra, 2016</td></tr><tr><td>Theory of Structuration</td><td>1</td><td>Luo, 2006</td></tr><tr><td>Socialization Theory</td><td>1</td><td>Muethel et al., 2011</td></tr><tr><td>Legitimacy Theory</td><td>1</td><td>Blanc et al., 2019</td></tr><tr><td>Diversification and Portfolio Theory</td><td>1</td><td>Jiménez, 2010</td></tr><tr><td>Stakeholder Theory</td><td></td><td>Roy &amp; Goll, 2014</td></tr><tr><td>Property Rights Theory</td><td>1 1</td><td>Driffield et al., 2016</td></tr><tr><td>Anomie Theory</td><td>1</td><td>Chen et al., 2015</td></tr><tr><td>Self-Selection Theory</td><td></td><td>Gomes et al., 2018</td></tr></table></body></html>

Note: The table lists the key theories used or tested by scholars in the literature on corruption in international business.

United Kingdom and India) between bribe-demanding and bribe-supplying countries may affect the propensity to engage in bribery (Baughn et al., 2010).

# 6.1.3. Combating corruption in international business

This research stream focuses on a practical analysis of anti-corruption measures and methods. An empirical examination of the impact of the extensive extraterritorial powers of the US, EU, and OECD on corruption in home and host countries across several industries is essential (Kaczmarek & Newman, 2011; Pacini et al., 2002). Cultural, economic, and individual factors might moderate this impact. Moreover, the interdependence between antecedents (at the national, firm, and individual levels) and consequences (at the national and firm levels) might affect the process of combating corruption in international business (Frei & Muethel, 2017).

# 6.1.4. The effect of corruption on firms in international business

This research area consists of studies on the challenges facing firms and the influence of corruption on them (Cuervo-Cazurra, 2008; Roy & Oliver, 2009; Uhlenbruck et al., 2006). Firms need to explore the cost and effect of corruption on their reputation, productivity, and export capabilities. Scholars must determine whether other variables such as entrepreneurship, innovation, and marketing capabilities mediate the relationship between corruption and a firm’s reputation, productivity,

# A.Antecedents

# A.1.Controls

# B. Corruption (Concepts)

# C.Consequences

# Firm-level Antecedents (Controls):

# Country(macro)Level-Hostand Home

# Country Factors:

Stream1:TheLegislationagainst corruption in IB ·Lack of intemational laws (Nichols, 2012;Everet et al.,2006). ·Non-enforcement of OECD convention and FCPA law in non-member countries (Klaw,2012;Kaikati et al.2000).

# Stream 2:Thedeterminants ofcorruption inIB

Economic Factors:   
·Higher taxes,Customs duties (Sanyal, 2005).   
·income inequality(Chen et al.,2015).   
·Financial Constraints (Lopatta et al. 2017).   
·Economic freedom index (Sanyal & Samanta,2017).   
Cultural Factors:   
·Power distance, individualism, masculinity, Uncertainty avoidance by Hofstede (Sanyal,20o9;Baughn et al., 2010)   
·Individual culture; performance-based culture (PBC),socially supportive culture (SSC)and gender egalitarianism culture (GEC) (Roy & Goll,2014).   
·Culture discrepancy (Gelbrich et al., 2016)   
Other Factors:   
·Coercive isomorphism:(govemment intervention and government efficiency) and mimetic isomorphism (Other firms bribery behaviors)(Gao,2011).   
·Corporate social responsibility index (Lopatta et al.,2017).   
·Democracy index (Sanyal & Samanta, 2017).   
·Human development index (Sanyal & Samanta,2017).   
·Gender of Manager and CEO (Tuliao & Chen,2017)

# Nature of Corruption:

# Demand-Sideof Corruptio

·financial and non-financial benefits to Public&Private Officials (Cuervo-Cazurra, 2016).   
2.Supply-Side of Corruption:   
·financial and non-financial benefits to individuals and firms/MNEs(Cuervo-Cazurra, 2016). Categories ofCorruption:   
·Public Corruption Organized corruption&Unorganized   
corruption (Shleifer&Vishmy, 1993).   
·Pettycorruption&Grand   
coruption (Elliot,1997).   
·Pervasive corruption & Arbitrary   
coruption (Rodriguez etal., 2005).   
·Private Corruption (Argandona 2003).   
Measurement of Corruption PrimarySources   
·Survey or structured interviews (Petrou,2015).   
Secondary Sources   
·Corruption perception index by Transparency intemational (Cuervo-Cazuira,2008).   
·World Bank Govemance index (Jensen et al., 2010).   
·The Intemational Country Risk Guide (Boubakri et al.,2013).

# Firm/MNEs Level Factors:

# Stream4:The EffectofCorruptionon Firm inIB

·Intemational Joint Ventures (IJV)(Roy& Oliver,2009;Heam,2015;Meschi,2009).   
·Eaming forecast and management (Chen et al.,2010;Lewellyn&Rosey，2017).   
·Prosocial values of the firm (Muethel et al., 2011).   
·Manager voluntary disclosure (Hung et al., 2018）   
·Export performance ofMNEs (Krammer et al.,2018).   
·Foreign afiliates/subsidiary performance (Petrou,205;Muelleretal,017).   
·Foreign affiliates ownership (Driffield et al.,2016).   
·MNEs activities volume and performance (Tunyi& Ntim，2016;Geleilate etal.,2016; Lee &Hong,2012).   
·Multinational enterprise social iresponsibility (CSiR) (Keig et al.,2015)   
·Entry mode strategy ofMNEs(Uhlenbruck et al.,2006).   
·SMEs performance (KouznetsovDass,& Schmidt,2014)   
·Corporate Risk -Taking (Boubakri et al.,2013).   
·Performance of mergers & acquision (M&A)(Brockman et al.,2013)   
·Organizational legitimacy and decision making (Rodriguez etal.,2005)

# A.2.Extension in Concepts of Corruption

Stream6:Corruptionasachallengetoexisting theoriesofmanagementinIB ·Extension of agency,transaction cost economics,resource dependence,resource-based view, andneo-institutional theories by considering corruption asa laboratory (Cuervo-Cazurra, 2016).

·Size,age,sales,volume,asset growth (Luo2006).   
·Industry, intemational experience,ownership (Roy& Oliver,2009).   
·Leverage,loss frequency,length of operating cycle (Chen et al.,2010).   
·Returnon assets,market to book ratio,earning to volatility, accounting standards (Hung et al.,2018).   
·Numberofsubsidiaries,profitability(Drifieldetal.2013)

# C.1.Consequences-Politics and Corruption

# Stream5:ThePolitical Environment andCorruption in

#

·Political conmected firms-low level of ethics engages in bribe-giving (Luo,2006).   
·Politicallobbying haspositive thancorruption-firm performance (Yim,Lu,& Choi,2017).   
·Political connected firms-low level of mergers & acquision (M&A) performance ifcoruption is low (Brockman,Rui,and Zou,2013)   
·Political connected firms-issue fewer eamings forecasts in corrupt countries (Hung,Kim,&Li,2018).

# D.Combating Corruption

# Stream3:CombatingCorruption in IB

![](images/5033025bcaed3d21fe4b2df745ca2fec863aa0c4ee3da5c74ae88523a0b66eaf.jpg)  
Fig. 4. A synthesis of the literature on corruption in IB.

·Foreign Corrupt PracticesAct of 1977 (Hotchkiss,1998)   
·USextraterritorial intervention against corruption (Kaczmarek& Newman,2011).   
·OECD convention (Cuervo-Cazura,2008).   
·Ethical standards,business codes (Rose-Ackerman,2002; Kaptein,2004). and export capabilities (Cleveland, Favo, Frecka, & Owens, 2009;   
Gomes et al., 2018).

Table 8 Future research questions.   

<html><body><table><tr><td>Research streams</td><td colspan="2">Future research questions</td><td>Author (s)/Year</td></tr><tr><td>The Legislation Against Corruption in International Business</td><td>1</td><td>What is the efect of EU,FCPA,and OECD conventions on corruption,particularly in countries that demand and supply bribes?</td><td>Darrough (2010)</td></tr><tr><td></td><td>2</td><td>How do the 1999 Australian Criminal Act and 1998 Canadian Corruption of Foreign Public Officials Act impact the propensity of Australian and Canadian individuals or MNEs to bribe foreign public officials in the home and host country?</td><td>Mijares (2015)</td></tr><tr><td>The Determinants of Corruption in International Business</td><td>3</td><td>Which combination of the gender of the principal (chair of the board) and manager (CEO)is more effective in reducing the firm&#x27;s propensity to bribe in CEO plurality firms?</td><td>Tuliao and Chen (2017)</td></tr><tr><td></td><td>4</td><td>What is the effect of cultural and economic factors on the country&#x27;s sustainability indicators such as environmental performance,human development,and the avoidance of corruption around the world? Is there any interrelationship among the</td><td>Roy and Goll (2014)</td></tr><tr><td></td><td>5</td><td>country&#x27;s sustainability indicators as well? How do prior colonial relationships (for example,the United Kingdom and India) between bribery-supplying and bribery-receiving countries affect the propensity to bribe in international business?</td><td>Baughn et al. (2010)</td></tr><tr><td>Combating Corruption in International Business</td><td>6</td><td>How do the extensive extraterritorial powers of the United States and the EU, such as financial services,antitrust laws,and product scope combat corruption in the host country,particularly in a highly corrupt industry and country? How do economic and cultural factors mediate this relationship?</td><td>Kaczmarek and Newman (2011)</td></tr><tr><td></td><td>7</td><td>Is there any interdependence between the antecedents (poor management, poor leadership,culture,economic factors,lack of the rule of law) and consequences (poverty,inflation,reduction in foreign direct investment,and trade) of corruption in international business? How does this interdependence impact the process of combating corruption?</td><td>Frei and Muethel (2017)</td></tr><tr><td>The Effect of Corruption on Firms in International Business</td><td>8</td><td>What is the actual cost of bribery such as fines,time and resources,and lawsuits for firms,and how does bribery affect the firm&#x27;s reputation?</td><td>Cleveland et al. (2009)</td></tr><tr><td></td><td>9</td><td>What is the effect of corruption on the firm&#x27;s productivity and exports,and how do other variables such as levels of entrepreneurship, innovation,and marketing capabilities mediate this relationship,particularly in highly corrupt countries?</td><td>Gomes et al. (2018)</td></tr><tr><td>The Political Environment and Corruption in International Business</td><td>10</td><td>What is the effect of political connections or political risk on the CSR activities of firms in the host and home country,and how does corruption play a moderating role?</td><td>Rodriguez et al. (2006)</td></tr><tr><td></td><td>11</td><td>Which has a stronger impact on the financial performance of the firm-corporate political activities (firm&#x27;s political connections or CEO&#x27;s political connections) or bribery in the host country,and do financial crises play a moderating role?</td><td>Yim et al. (2017)</td></tr><tr><td>Corruption as a Challenge to Existing Theories of Management in International Business</td><td>12</td><td>How can we extend the existing theories of the firm (agency, transaction cost economics,resource-based view,resource-dependence,and neo-institutional theory) by considering corruptionasa laboratory in international business?</td><td>Cuervo-Cazurra (2016)</td></tr><tr><td>The Effect of Corruption on Foreign Direct Investment and Trade in International Business</td><td>13</td><td>What is the effect of political connections or political risk on inward and outward foreign direct investment in the home and host country,and how does corruption</td><td>Rodriguez et al. (2006), Cuervo- Cazurra (2006)</td></tr><tr><td></td><td>14</td><td>moderate this link? What is the effect of corruption on inward and outward foreign direct investment in the home and host country,and how do political connections or political risk</td><td>Rodriguez et al. (2006), Cuervo- Cazurra (2006)</td></tr></table></body></html>

Note: The table lists 14 future research questions.

# 6.1.5. The political environment and corruption in international business

This stream focuses on the relationship between politics, corporate social responsibility, and corruption in international business (Galang, 2012; Luo, 2006). Future research in the field could investigate the direct and indirect associations between these components. It could also examine the effect of political connections or political risks on the corporate responsibility activities of multinational enterprises and whether corruption moderates this association (Rodriguez et al., 2006). Furthermore, a comparison of the relative advantages of corporate political lobbying vs. bribery for a firm’s performance and how financial crises moderate this relationship would help managers choose between the two approaches (Yim et al., 2017).

6.1.6. Corruption as a challenge to existing theories of management in international business

This research stream is in its infancy. Given that corruption is a very complex problem, Cuervo-Cazurra (2016) recommends revisiting and confirming existing theories of the firm (agency, transaction cost economics, resource-based view, resource-dependence, and neo-institutional theory) by considering corruption as a laboratory.

# 6.1.7. The effect of corruption on foreign direct investment and trade in international business

This stream builds on studies that explore the effect of corruption on foreign direct investment (FDI) and trade in international business (Habib & Zurawicki, 2002). Future research could focus on the impact of political connections or political risks on inward and outward foreign direct investment and the moderating effect of corruption in the home and host countries. We also suggest broadening this focus to explore the impact of corruption on inward and outward foreign direct investment and the moderating role of political connections or political risks in the home and host countries (Cuervo-Cazurra, 2006; Rodriguez et al., 2006).

# 6.2. Gaps in our knowledge and propositions for dealing with them

Our review also revealed a number of gaps in our knowledge about corruption in international business related to context, methods, theoretical frameworks, and measurements (Gilal, Zhang, Paul, & Gilal, 2019; Kedia & Lahiri, 2007; Paul & Rosado-Serrano, 2019; Paul & Sánchez‐Morcilio, 2019; Terjesen et al., 2013). We discuss these research gaps and our proposals for dealing with them below.

# 6.2.1. Context of key studies

The most cited articles examine the effect of corruption on the firm (e.g., Keig et al., 2015; Lee & Hong, 2012; Hearn, 2015; Tunyi & Ntim, 2016). Indeed, the firm is the main topic of interest in international business. However, we observed that, when analyzing the relationship between corruption and the firm, researchers control for firm-level factors such as performance, operations, earnings management, and profitability. We believe that researchers should examine the relationship between corruption and firm-level factors, which are controlled in the literature. Therefore, we propose that:

Proposition 1. Firm-level factors such as age, industry, size, international experience, ownership, sales, loss frequency, and length of the operating cycle prompt firms to engage in bribery when conducting international business.

# 6.2.2. Key methods

Table 5 reports that studies on corruption in international business usually use content analysis (Cuervo-Cazurra, 2016; Krueger, 2009), regressions (Boubakri et al., 2013; Jiménez, 2011), and document analysis (Kaptein, 2004; Pacini et al., 2002). However, a challenge for international business researchers is to confirm the effect of corruption on firms, their tendency to engage in bribery, and inward foreign direct investment. To accomplish these goals, other forms of analysis are needed. Therefore, we propose that:

Proposition 2. Utilizing meta-analysis and network analysis will be useful in exploring the effect of corruption on firms, their tendency to engage in bribery, and inward foreign direct investment at the firm and country level.

# 6.2.3. Measurement of corruption

Most studies used data about corruption from country-level indexes such as Transparency International, World Governance Indicators, and the International Country Risk Guide. As Table 6 indicates, only six papers used primary firm-level survey data. We believe that firm-level surveys and interviews about corruption will be useful in identifying anti-corruption measures in international business. Therefore, we propose that:

Proposition 3. A firm-level survey to measure the level of corruption and identify the factors that lead to a firm to engage in bribery will be useful for initiating attempts to combat corruption in international business.

# 6.2.4. Theoretical frameworks

The most frequently utilized framework to predict a firm’s engagement in corruption in international business is an institutional theory (Dikova et al., 2016; Krammer et al., 2018; North, 1990; Scott, 1995). Based on this framework, the literature suggests that by improving the quality of institutions, the adverse effects of corruption can be minimized in international business. Therefore, we propose that:

Proposition 4. Improving the quality of institutions in terms of the rule of law and the structure of government will reduce the level of corruption and tendency of a firm to engage in bribery when conducting international business.

The second most frequently utilized theoretical framework is the neo-institutional perspective, which is quite popular in the organizational field and international business. It maintains that firms respond to the cognitive, normative, and regulatory pressures of the community and society where they operate (DiMaggio & Powell, 1983). Gao (2010) also confirmed the effect of mimetic isomorphism on the tendency of international firms operating in China to engage in bribery because they see other firms in the business community doing so. Consequently, we posit that:

Proposition 5. Coercive, mimetic, and normative isomorphism affect the level of corruption at the country level as well.

Finally, researchers utilize agency theory to explore corruption and international business (Boubakri et al., 2013; Chen et al., 2015; Stulz, 2005; Tuliao & Chen, 2017). Managers’ decisions to engage in bribery and corrupt activities nationally and internationally result in agency problems. However, managers defend these actions on the grounds that they are beneficial for the firm. Therefore, we propose that:

Proposition 6. The firm’s managers' involvement in bribery and corrupt activities nationally and internationally is for their own self-interests rather than those of the firm, which leads to agency problems.

# 7. Conclusion

Based on our in-depth review of corruption in international business, we have several policy recommendations. First, strong international laws are needed to minimize the negative impact of corruption on foreign direct investment, trade, business, and firms. Second, firms are the key players in international business. Therefore, managers and policymakers need to consider corruption when formulating the firms’ organizational structure and creating strategies to increase operational efficiency and performance. Third, the establishment of an organizational anti-corruption architecture system in firms is essential to overcome corruption in international business. Finally, corruption challenges some key assumptions of existing theories of management. Scholars need to test and expand these existing theories by considering corruption as an important issue in international business.

# Appendix A

Table A1 The list of papers that creates the citation map.   

<html><body><table><tr><td>No.on Map</td><td>Authors/Year</td><td></td><td></td><td>TLC TGC No.on Map</td><td>Authors/Year</td><td></td><td></td><td>TLC TGCNo.on Map</td><td>Authors/Year</td><td></td><td>TLC TGC</td></tr><tr><td colspan="10">37 influential articles based on TLC ≥ 1</td></tr><tr><td>1</td><td>Armstrong (1992)</td><td>1</td><td>16</td><td>26</td><td>Luo (2006)</td><td>6</td><td>98</td><td>47</td><td>Chen et al. (2010)</td><td></td><td>59</td></tr><tr><td>3</td><td>Tsalikis and Latour (1995)</td><td>1</td><td>29</td><td>29</td><td>Argandona (2003)</td><td>1</td><td>18</td><td>51</td><td>Mazar and Aggarwal (2011)</td><td></td><td>58</td></tr><tr><td>4</td><td>Hotchkiss (1998)</td><td>1</td><td>30</td><td>33</td><td> Sanyal and Guvenli</td><td>3</td><td>12</td><td>52</td><td>Osuji (2011)</td><td>1</td><td>26</td></tr><tr><td></td><td>George et al. (1998)</td><td></td><td>41</td><td>37</td><td>(2009) Roy and Oliver (2009)</td><td>1</td><td>49</td><td>56</td><td>Guvenli and Sanyal (2012)</td><td></td><td>1</td></tr><tr><td>8 9</td><td>Kaikati et al. (2000)</td><td>5 6</td><td>26</td><td>38</td><td>Krueger (2009)</td><td>1</td><td>6</td><td>58</td><td>Galang (2012)</td><td></td><td>30</td></tr><tr><td>11</td><td>Pacini et al. (2002)</td><td>6</td><td>26</td><td>39</td><td>Cleveland et al. (2009)</td><td>3</td><td>26</td><td>59</td><td>Nichols (2012)</td><td>1 1</td><td>12</td></tr><tr><td>14</td><td>Doh et al. (2003)</td><td>11</td><td></td><td>10441</td><td>Baughn et al. (2010)</td><td>3</td><td>32</td><td>60</td><td>Klaw (2012)</td><td>1</td><td>5</td></tr><tr><td>15</td><td>Kaptein (2004)</td><td>1</td><td>197</td><td>42</td><td>Darrough (2010)</td><td>1</td><td>12</td><td>61</td><td>Antonakas, Giokas, and Konstantopoulos (2013)</td><td>2</td><td>2</td></tr><tr><td>17</td><td>Weber and Getz (2004)</td><td>3</td><td>13</td><td>45</td><td>Franke and Richey</td><td>1</td><td>41</td><td>62</td><td>Lawton et al. (2012)</td><td>1</td><td>75</td></tr><tr><td>20</td><td>Rodriguez et al. (2005)</td><td>15</td><td></td><td>20046</td><td>(2010) Jensen et al. (2010)</td><td>7</td><td></td><td>64</td><td>Boubakri et al. (2013)</td><td></td><td></td></tr><tr><td>21</td><td>Sanyal (2005)</td><td>14</td><td>66</td><td>47</td><td>Chen et al. (2010)</td><td>8</td><td>42 59</td><td>65</td><td>Lambsdorff (2013)</td><td>1 1</td><td>43 10</td></tr><tr><td>24</td><td>Uhlenbruck et al. (2006)</td><td>12</td><td>150</td><td>51</td><td> Mazar and Aggarwal</td><td>3</td><td>58</td><td>67</td><td>Brockman et al. (2013)</td><td>1</td><td>29</td></tr><tr><td>25</td><td>Rodriguez et al. (2006)</td><td>8</td><td></td><td>18152</td><td>(2011) Osuji (2011)</td><td>1</td><td>26</td><td>82</td><td>Chen et al. (2015)</td><td>1</td><td></td></tr><tr><td>102</td><td>Lord and Levi (2017)</td><td>1</td><td>3</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>2</td></tr><tr><td colspan="10">The 39 articles that cited these 37 influential articles.</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td>Gelbrich et al. (2016)</td><td>0</td><td>1</td><td>70</td><td>Kouznetsov et al. (2014)</td><td></td><td></td></tr><tr><td>23 75</td><td>Everett et al. (2006) Foster (2015)</td><td>0 0</td><td>37 1</td><td>90 101</td><td> Xie et al. (2017)</td><td>0</td><td>11</td><td>104</td><td>Jiménez, Marcelus, Guoliang,&amp; Jiang,</td><td>0 0 2</td><td>3</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>2017)</td><td></td><td></td></tr><tr><td>54</td><td>Spalding (2011)</td><td>0</td><td>9</td><td>107</td><td>Yi et al. (2017)</td><td>0</td><td>0</td><td>112</td><td>Hung et al. (2018)</td><td>0</td><td>0</td></tr><tr><td>44 80</td><td>Gao (2010)</td><td>0</td><td>3</td><td>27</td><td>Cuervo-Cazurra (2006) Cuervo-Cazurra (2008)</td><td>0</td><td>196</td><td>114</td><td>Mukherjee (2018) Lewellyn and Rosey (2017)</td><td>0</td><td>0</td></tr><tr><td>103</td><td>Mijares (2015) Frei and Muethel (2017)</td><td>0 0</td><td>1 0</td><td>30 55</td><td>Wenhao and Ahmad</td><td>0 0</td><td>70 1</td><td>105 115</td><td>Karhunen et al. (2018)</td><td>0 0</td><td>0 0</td></tr><tr><td>53</td><td></td><td></td><td></td><td></td><td>(2011)</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Kaczmarek and Newman (2011)</td><td>0</td><td>24</td><td>88</td><td>Cuervo-Cazurra (2016)</td><td>0</td><td>28</td><td>91</td><td>Laudone (2016)</td><td>0</td><td>1</td></tr><tr><td>50 81</td><td>Gao (2011) Huang, Liu, Zheng, Tan,&amp;</td><td>0</td><td>3 2</td><td>100</td><td>Yim et al. (2017) Petrou (2015)</td><td>0 0</td><td>2 1</td><td>36 19</td><td>Pedigo and Marshall (2009) Windsor (2005)</td><td>0 0</td><td>6</td></tr><tr><td></td><td>Zhao, 2015</td><td>0</td><td></td><td>84</td><td></td><td></td><td></td><td></td><td></td><td></td><td>0</td></tr><tr><td>99 98</td><td> Tuliao and Chen (2017)</td><td>0 0</td><td>3 0</td><td>72 106</td><td>Roy and Goll (2014) Gomes et al. (2018)</td><td>0 0</td><td>10 0</td><td>12 68</td><td>Rose-Ackerman (2002) Antonakas, Konstantopoulos, and</td><td>0</td><td>39</td></tr><tr><td></td><td>Sanyal and Samanta (2017)</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>Seimenis (2014)</td><td>0</td><td>0</td></tr><tr><td>66 92</td><td>Wu and Huang (2013)</td><td>0</td><td>0</td><td>63</td><td>Driffield et al. (2013)</td><td>0</td><td>21</td><td>113</td><td>Lord et al. (2018)</td><td>0</td><td>2</td></tr><tr><td></td><td>Srivastava et al. (2016)</td><td>0</td><td>8</td><td>97</td><td>Oesterle and Bjorn (2017)</td><td>0</td><td>0</td><td></td><td></td><td></td><td></td></tr></table></body></html>

Note: The table shows the details of the 76 articles that shape the citation map. They include the original 37 influential articles based on TLC $\geq 1$ plus the 39 articles that cite these 37 influential articles.

# References

Abbott, K. W. (2001). Rule- making in the WTO: Lessons from the case of bribery and corruption. Journal of International Economic Law, 4(2), 275–296.   
Ahmed, F., Bahoo, S., & Ayub, A. (2019). Accountability, governance, and structure of non-profit organizations: Evidence from Ghana, South Africa, and Zimbabwe. New Horizons, 13(2), 19–36.   
Ahmed, F., Bahoo, S., Aslam, S., & Qureshi, M. A. (2020). Meta-analysis on American Presidential Election-2016 and American Stock Market. Estudios de Economia Aplicada, 38(1), 1–7.   
Alon, I., Anderson, J., Munim, Z. H., & Ho, A. (2018). A review of the internationalization of Chinese enterprises. Asia Pacific Journal of Management, 35(3), 573–605.   
Antonakas, N. P., Giokas, A. E., & Konstantopoulos, N. (2013). Corruption in Tax Administration: Interviews with Experts. Procedia - Social and Behavioral Sciences, 73(27), 581–589.   
Antonakas, N. P., Konstantopoulos, N., & Seimenis, I. (2014). Human resource management’s role in the public sector and the level of corruption: The case of greek tax administration. Procedia - Social and Behavioural Sciences, 148, 455–462.   
Apriliyanti, I. D., & Alon, I. (2017). Bibliometric analysis of absorptive capacity. International Business Review, 26(5), 896–907.   
Argandona, A. (2003). Private-to-private corruption. Journal of Business Ethics, 47(3), 253–267.   
Argandoña, A. (2007). The united nations convention against corruption and its impact on international companies. Journal of Business Ethics, 74, 481.   
Armstrong, R. W. (1992). An empirical investigation of international marketing ethics: Problems encountered by Australian firms. Journal of Business Ethics, 11(3), 161–171.   
Bahoo, S., Alon, I., & Paltrinieri, A. (2019). Sovereign wealth funds: Past, present, and future. International Review of Financial Analysis (In Press).   
Bahoo, S., Hassan, M. K., Paltrinieri, A., & Khan, A. (2019). A model of the islamic sovereign wealth fund. Islamic Economic Studies, 27(1), 2–22.   
Bahoo, S., Saeed, S., Iqbal, M. J., & Nawaz, S. (2018). Role of China-Pakistan economic corridor in Pakistan’s trade, investment, energy, infrastructure, and stock market. Journal of Independent Studies and Research-Management, Social Sciences and Economics, 16(1), 63–84.   
Baughn, C., Bodie, N. L., Buchanan, M. A., & Bixby, M. B. (2010). Bribery in international business transactions. Journal of Business Ethics, 92(1), 15–32.   
Blanc, R., Cho, C. H., Sopt, J., & Branco, M. C. (2019). Disclosure responses to a corruption scandal: The case of siemens AG. Journal of Business Ethics, 156(2), 545–561.   
Bondy, K., Matten, D., & Moon, J. (2008). Multinational corporation codes of conduct: Governance tools for corporate social responsibility? Corporate Governance-An International Review, 16(4), 294–311.   
Boubakri, N., Mansi, S. A., & Saffar, W. (2013). Political institutions, connectedness, and corporate risk-taking. Journal of International Business Studies, 44(3), 195–215.   
Brada, J. C., Drabek, Z., & Perez, M. F. (2012). The effect of home-country and hostcountry corruption on foreign direct investment. Review of Development Economics, 16(4), 640–663.   
Brockman, P., Rui, O. M., & Zou, H. (2013). Institutions and the performance of politically connected M & As. Journal of International Business Studies, 44, 833–852.   
Caiden, G. E., Dwivedi, O. P., & Jabbra, J. G. (2001). Where corruption lives. Boulder, CO:

Lynne Rienner Publishers. Carmichael, S. (1995). Business ethics: The new bottom line. London: Demos. Carvalho, J., Isnard, M., De Almeida, R., & Rosa, N. (2014). Mergers & acquisitions research: A bibliometric study of top strategy and international business journals, 1980–2010. Journal of Business Research, 67(12), 2550–2558. Celentani, M., Ganuza, J., & Peydro, J. (2004). Combating corruption in international business transactions. Economica, 71(283), 417–448. Chen, C., Cullen, J. B., & Parboteeah, K. P. (2015). Are manager-controlled firms more likely to bribe than shareholder-controlled firms: A cross-cultural analysis. Management and Organization Review, 11(2), 343–365. Chen, C. J. P., Ding, Y., & Kim, C. F. (2010). High-level politically connected firms, corruption, and analyst forecast accuracy around the world. Journal of International Business Studies, 41(9), 1505–1524. Cleveland, M., Favo, C. M., Frecka, T. J., & Owens, C. L. (2009). Trends in the international fight against bribery and corruption. Journal of Business Ethics, 90(S2), 199–244. Cuervo-Cazurra, A. (2006). Who cares about corruption? Journal of International Business Studies, 37(6), 807–822. Cuervo-Cazurra, A. (2008). The effectiveness of laws against bribery abroad. Journal of International Business Studies, 39(4), 634–651. Cuervo-Cazurra, A. (2016). Corruption in international business. Journal of World Business, 51(1), 35–49. Czinkota, M. R., & Ronkainen, I. A. (2019). Trends and indications in international business: Topics for future research. Management International Review, 49(2), 249–265. Czinkota, M. R., & Skuba, C. J. (2014). Contextual analysis of legal systems and their impact on trade and foreign direct investment. Journal of Business Research, 67(10), 2007–2211. Darrough, N. M. (2010). The FCPA and the OECD convention: Some lessons from the U.S. experience masako. Journal of Business Ethics, 93(2), 255–276. Das-Gupta, A., & Wu, X. (2008). Corporate ownership and bribery. Singapore: Manuscript, Lee Kuna Yew School of Public Policy, National University of Singapore. Dikova, D., Panibratov, A., Veselova, A., & Ermolaeva, L. (2016). The joint effect of investment motives and institutional context on russian international acquisitions. International Journal of Emerging Markets, 11(4), 674–692. DiMaggio, P. J., & Powell, W. W. (1983). The iron cage revisited: Institutional isomorphism and collective rationality in organizational fields. American Sociological Review, 48(2), 147–160. Doh, J. P., Rodriguez, P., Uhlenbruck, K., Collins, J., & Shekshnia, S. (2003). Coping with corruption in foreign markets. Academy of Management Executives, 17(3), 114–129. Driffield, N., Jones, C., & Crotty, J. (2013). International business research and risky investments, an analysis of FDI in conflict zones. International Business Review, 22(1), 140–155. Driffield, N., Mickiewicz, T., & Temouri, Y. (2016). Ownership control of foreign affiliates: A property rights theory perspective. Journal of World Business, 51(6), 965–976. Dzikowski, P. (2018). A bibliometric analysis of born global firms. Journal of Business Research, 85, 281–294. Egger, P., & Winner, H. (2005). Evidence on corruption as an incentive for foreign direct investment. European Journal of Political Economy, 21(4), 932–952. Elliott, K. A. (Ed.). (1997). Corruption and the global economy. Washington, DC: Institute for International Economics. Everett, J., Neu, D., & Rahaman, A. S. (2006). The global fight against corruption: A foucaultian, virtues-ethics framing. Journal of Business Ethics, 65(1), 1–12. Everett, J., Neu, D., & Rahaman, A. S. (2007). Accounting and the global fight against corruption. Accounting Organizations and Society, 32(6), 513–542. Fard, B. R., & Hassanpour, H. (2016). Reviewing the strategies of dealing with corruption in the Europe Union Countries with regulatory system of the group of states against corruption (GRECO). Journal of Politics and Law, 9(5), 190–191. Fernando, P., & Serra, R. (2014). The transaction costs theory in international business research: A bibliometric study over three decades. Scientometrics, 98(3), 1899–1922. Fetscherin, M., Voss, H., & Gugler, P. (2010). 30 years of foreign direct investment to China: An interdisciplinary literature review. International Business Review, 19(3), 235–246. Foster, G. K. (2015). Combating bribery of indigenous leaders in international business. Columbia Journal of Transnational Law, 59(1), 59–115. Franke, G. R., & Richey, R. G., Jr. (2010). Improving generalizations from multi-country comparisons in international business research. Journal of International Business Studies, 41(8), 1275–1293. Frei, C., & Muethel, M. (2017). Antecedents and consequences of MNE bribery: A multilevel review. Journal of Management Inquiry, 26(4), 418–432. Funk, C., Treviño, L. J., & Funk, C. (2017). Economy relationships Institution building in retreat: The effects of co-devolution on MNE-emerging economy relationships. Cross Cultural & Strategic Management, 24(3), 436–453. Galang, R. M. N. (2012). Victim or victimizer: Firm responses to government corruption. Journal of Management Studies, 49(2), 429–462. Gantz, D. (1998). Globalizing sanctions against foreign bribery: The emergence of a new international legal consensus. North-western Journal of International Law & Business, 18(2), 457–497. Gao, Y. (2010). Mimetic isomorphism, market competition, perceived benefit, and bribery of firms in transitional China. Australian Journal of Management, 35(2), 203–222. Gao, Y. (2011). Isomorphic effect and organizational bribery in transitional China. Asian Business and Management, 10(2), 233–257. Gaur, A., & Kumar, M. (2018). A systematic approach to conducting review studies: An assessment of content analysis in 25 years of IB research. Journal of World Business, 53(2), 280–289. Gelbrich, K., Stedham, Y., & Gathke, D. (2016). Cultural discrepancy and national

corruption: Investigating the difference between cultural values and practices and its relationship to corrupt behavior. Business Ethics Quarterly, 26(2), 201–225.   
Geleilate, J. G., Magnusson, P., Parente, R. C., & Alvarado-Vargas, M. J. (2016). Home country institutional effects on the multinationality – Performance relationship: A comparison between emerging and developed market multinationals. Journal of International Management, 22(4), 380–402.   
George, C. B., Lacey, A. K., & Birmele, J. (1998). The 1998 OECD convention: An impetus for worldwide changes in attitudes toward corruption in business transactions. American Business Law Journal, 37(3), 485.   
Gilal, F. G., Zhang, J., Paul, J., & Gilal, N. G. (2019). The role of self-determination theory in marketing science: An integrative review and agenda for research. European Management Journal, 37(1), 29–44.   
Gomes, E., Vendrell-herrero, F., Mellahi, K., Angwin, D., & Sousa, C. M. P. (2018). Testing the self-selection theory in high corruption environments: Evidence from African SMEs. International Marketing Review, 35(5), 733–759.   
Gomezelj, D. G. (2016). A systematic review of research on innovation in hospitality and tourism. International Journal of Contemporary Hospitality Management, 28(3), 516–558.   
Guo, Y., Rammal, H. G., Benson, J., Zhu, Y., & Dowling, P. J. (2018). Interpersonal relations in China: Expatriates’ perspective on the development and use of guanxi. International Business Review, 27(2), 455–464.   
Guvenli, T., & Sanyal, R. (2012). Perception and understanding of bribery in international business. Ethics and Behavior, 22(5), 333–348.   
Habib, M., & Zurawicki, L. (2002). Corruption and foreign direct investment. Journal of International Business Studies, 33(2), 291–307.   
Hamir, M. A. (1999). Keynote address. In K. Frimpong, & G. Jacques (Eds.). Corruption, democracy and good governance in Africa: Essays on accountability and ethical behaviour. Gaborone, Botswana: Light books.   
Hawley, A. (1968). Human ecology. In D. L. Sills (Ed.). International encyclopedia of the social sciences (pp. 328–337). New York: Macmillan.   
He, C., Xie, X., & Zhu, S. (2015). Going global: Understanding China’s outward foreign direct investment from motivational and institutional perspectives. Post-Communist Economies, 27(4), 448–471.   
Hearn, B. (2015). Institutional influences on board composition of international joint venture firms listing on emerging stock exchanges: Evidence from Africa. Journal of World Business, 50(1), 205–219.   
Hefendehl, R. (2010). Addressing white collar crime on a domestic level. Journal of International Criminal Justice, 8(3), 769–782.   
Heimann, F., & Boswell, N. Z. (1998). The OECD convention: Milestone on the road to reform. In Transparency International (Ed.). New perspectives on combating corruption. Washington: Transparency International.   
Hillman, A. J. (2005). Politicians on the board of directors: Do connections affect the bottom line? Journal of Management, 31(3), 464–481.   
Hofstede, G. (1980). Culture’s consequences: International differences in work-related values. Newbury Park, California: Sage Publications.   
Horak, S. (2018). Join in or opt out? A normative – Ethical analysis of affective ties and networks in South Korea. Journal of Business Ethics, 149(1), 207–220.   
Hotchkiss, C. (1998). The sleeping dog stirs: New signs of life in efforts to end corruption in international business. Journal of Public Policy & Marketing, 17(1), 108–115.   
Huang, Z., Liu, L., Zheng, W., Tan, X., & Zhao, X. (2015). Walking the straight and narrow: The moderating effect of evaluation apprehension on the relationship between collectivism and corruption. PLoS One, 10(3), 1–12. https://doi.org/10.1371/ journal.pone.0123859.   
Hub, S. C., & Shing, T. N. (2016). Ethical negotiation values of Chinese negotiators. Journal of Business Research, 69(2), 823–830.   
Hung, M., Kim, Y., & Li, S. (2018). Political connections and voluntary disclosure: Evidence from around the world. Journal of International Business Studies, 49(3), 272–302.   
Iddy, J. J., & Alon, I. (2019). Knowledge management in franchising: A research agenda. Journal of Knowledge Management, 23(4), 763–785. https://doi.org/10.1108/JKM-07- 2018-0441.   
Jensen, M. C., & Meckling, W. H. (1976). Theory of the firm: Managerial behavior, agency costs and ownership structure. Journal of Financial Economics, 3(4), 305–360.   
Jensen, N. M., Li, Q., & Rahman, A. (2010). Understanding corruption and firm responses in cross-national firm-level surveys. Journal of International Business Studies, 41(9), 1481–1504.   
Jiménez, A. (2010). Does political risk affect the scope of the expansion abroad? Evidence from spanish MNEs. International Business Review, 19(6), 619–633.   
Jiménez, A. (2011). Political risk as a determinant of southern european FDI in neighboring developing countries. Emerging Market Finance and Trade, 47(4), 59–74.   
Jiménez, A., & Bjorvatn, T. (2018). The building blocks of political risk research: A bibliometric co-citation analysis. International Journal of Emerging Markets, 13(4), 631–652.   
Jiménez, A., Marcelus, J., Guoliang, K., & Jiang, F. (2017). Corruption and private participation projects in central and Eastern Europe. Management International Review, 57(5), 775–792.   
Kaczmarek, S. C., & Newman, A. L. (2011). The long arm of the law: Extraterritoriality and the national implementation of foreign bribery legislation. International Organization, 65(4), 745–770.   
Kaikati, J. G., Sullivan, G. M., Virgo, J. M., Carr, T. R., & Virgo, K. S. (2000). The price of international business morality: Twenty years under the foreign corrupt practices act. Journal of Business Ethics, 26(3), 213–222.   
Kaptein, M. (2004). Business codes of multinational firms: What do they say? Journal of Business Ethics, 50(1), 13–31.   
Karhunen, P., Kosonen, R., Mccarthy, D. J., & Puffer, S. M. (2018). The darker side of social networks in transforming economies: Corrupt exchange in Chinese Guanxi and Russian Blat/Svyazi. Management and Organization Review, 14(2), 395–419.   
Kedia, B. L., & Lahiri, S. (2007). International outsourcing of services: A partnership model. Journal of International Management, 13(1), 22–37.   
Keig, D. L., Brouthers, L. E., & Marshall, V. B. (2015). Formal and informal corruption environments and multinational enterprise social irresponsibility. Journal of Management Studies, 52(1), 98–116.   
Kim, J., & McMillan, S. J. (2008). Evaluation of internet advertising research: A bibliometric analysis of citations from key sources. Journal of Advertising, 37(1), 99–112.   
Klaw, B. W. (2012). A new strategy for preventing bribery and extortion in international business transactions. Harvard Journal on Legislation, 49(2), 303–371.   
Koerber, C. P. (2010). Corporate responsibility standards: Current implications and future possibilities for peace through commerce. Journal of Business Ethics, 89(4), 461–480.   
Kouznetsov, A., Dass, M., & Schmidt, P. (2014). Entry mode decisions the effects of corruption and weak law enforcement on foreign manufacturing SMEs in post-communist Russia. Baltic Journal of Management, 9(3), 277–293.   
Krammer, S. M. S., Strange, R., & Lashitew, A. (2018). The export performance of emerging economy firms: The influence of firm capabilities and institutional environments. International Business Review, 27(1), 218–230.   
Krueger, D. A. (2009). Ethical reflections on the opportunities and challenges for international business. Journal of Business Ethics, 89(2), 145–156.   
Lambsdorff, J. G. (2013). Corruption intermediaries in international business transactions; between make, buy, and reform. European Journal of Law Economics, 35(3), 349–366.   
Laudone, S. S. (2016). The foreign corrupt practices act: Unbridled enforcement and flawed culpability standards deter SMEs from entering the global marketplace. Journal of Criminal Law and Criminology, 106(2), 355–404.   
Lawton, T., Mcguire, S., & Rajwani, T. (2012). Corporate political activity: A literature review and research agenda. International Journal of Management Reviews, 15, 86–105.   
Lee, S., & Hong, S. J. (2012). Corruption and subsidiary profitability: US MNC subsidiaries in the Asia Pacific Region. Asia Pacific Journal of Management, 29(4), 949–964.   
Lewellyn, K. B., & Rosey, S. (2017). The role of national culture and corruption on managing earnings around the world. Journal of World Business, 52(6), 798–808.   
Lopatta, K., Jaeschke, R., Tchikov, M., & Lodhia, S. (2017). Corruption, corporate social responsibility and financial constraints: International firm ‐ level evidence. European Management Review, 14, 47–65.   
Lord, N., & Levi, M. (2017). Organizing the finances for and the finances from transnational corporate bribery. European Journal of Criminology, 14(3), 365–389.   
Lord, N., Wingerde, V. K., & Campbell, L. (2018). Organizing the monies of corporate financial crimes via organisational structures: Ostensible legitimacy, effective anonymity, and third-party facilitation. Administrative Science, 8, 0–17.   
Luo, Y. (2006). Political behavior, social responsibility, and perceived corruption: A structuration perspective. Journal of International Business Studies, 37(6), 747–766.   
Marat, E. (2015). Global money laundering and its domestic political consequences in Kyrgyzstan. Central Asian Survey, 34(1), 46–56.   
Maria, W. D. (2010). Why is the president of Malawi angry? Towards an ethnography of corruption. Culture and Organization, 16(2), 145–162.   
Martin, K. D., Cullen, J. B., Johnson, J. L., & Parboteeah, K. P. (2019). Bribery activity deciding to bribe: A cross-level analysis of firm and home country influences on bribery activity. The Academy of Management Journal, 50(6), 1401–1422.   
Mauro, P. (1995). Corruption and growth. The Quarterly Journal of Economics, 110(3), 681–712.   
Mazar, N., & Aggarwal, P. (2011). Greasing the palm: Can collectivism promote bribery? Psychological Science, 22(7), 843–848.   
Meschi, P. (2009). Government corruption and foreign stakes in international joint ventures in emerging economies. Asia Pacific Journal of Management, 26(2), 241–261.   
Meyer, J. W., & Rowan, B. (1977). Institutionalized organizations: Formal structure as myth and ceremony. American Journal of Sociology, 83(2), 340–363.   
Mijares, S. C. (2015). The global fight against foreign bribery: Is Canada a leader or a laggard? Western Journal of Legal Studies, 5(4), 1–24.   
Mornah, D., & Macdermott, R. J. (2018). A non-proxied empirical investigation of cultures effect on corruption. Business and Society Review, 123(2), 269–301.   
Muellner, J., Klopf, P., & Nell, P. C. (2017). Trojan horses or local allies: Host-country national managers in developing market subsidiaries. Journal of International Management, 23(3), 306–325.   
Muethel, M., Hoegl, M., & Parboteeah, K. P. (2011). National business ideology and employees’ prosocial values. Journal of International Business Studies, 42(2), 183–201.   
Mukherjee, D. (2018). Corruption in international business: Does economic globalization help? Global Business Review, 19(13), 623–634.   
Naatu, F., & Alon, I. (2019). Social franchising: A bibliometric and theoretical review. Journal of Promotion Management, 25(5), 738–764. https://doi.org/10.1080/ 10496491.2019.1584777.   
Nichols, P. M. (2012). The business case for complying with bribery laws. American Business Law Journal, 49(2), 325–368.   
North, D. C. (1990). Institutions, institutional change, and economic performance. Cambridge, UK: Cambridge University Press.   
Oesterle, M.-J., & Bjorn, R. (2017). Not trading favours: MNE activity in economies shaped by institutional voids. European Journal of International Management, 11(6), 11–13.   
Oliver, C. (1991). STRATEGIC RESPONSES TO INSTITUTIONAL PROCESSES. Academy of Management Review, 16(1), 145–179.   
Osuji, O. (2011). Fluidity of regulation-CSR Nexus: The multinational corporate corruption example. Journal of Business Ethics, 103(1), 31–57.   
Øyna, S., & Alon, I. (2018). A review of born globals. International Studies of Management & Organization, 48(2), 157–180.   
Pacini, C., Swingen, J. A., & Rogers, H. (2002). The role of the OECD and EU conventions in combating bribery of foreign public officials. Journal of Business Ethics, 37(4), 385–405.   
Pajunen, K. (2008). Institutions and inflows of foreign direct investment: A fuzzy-set analysis. Journal of International Business Studies, 39(4), 652–669.   
Paltrinieri, A., Hassan, M. K., Bahoo, S., & Khan, A. (2019). A bibliometric review of sukuk literature. International Review of Economics & Finance (In Press).   
Pantzalis, C., Chul, J., & Sutton, N. (2008). Corruption and valuation of multinational corporations. Journal of Empirical Finance, 15(3), 387–417.   
Paul, J., & Benito, G. R. G. (2018). A review of research on outward foreign direct investment from emerging countries, including China: what do we know, how do we know and where should we be heading? Asia Pacific Business Review, 24(1), 90–115.   
Paul, J., Parthasarathy, S., & Gupta, P. (2017). Exporting challenges of SMEs: A review and future research agenda. Journal of World Business, 52(3), 327–342.   
Paul, J., & Rosado-Serrano, A. (2019). Gradual internationalization vs. born-global/international new venture models: A review and research agenda. International Marketing Review, 36(6), 830–858. https://doi.org/10.1108/IMR-10-2018-0280.   
Paul, J., & Sánchez‐Morcilio, R. (2019). Toward a new model for firm internationalization: Conservative, predictable, and pacemaker companies and markets. Canadian Journal of Administrative Sciences, 36(3), 336–349.   
Paul, J., & Singh, G. (2017). The 45 years of foreign direct investment research: Approaches, advances, and analytical areas. World Economy, 40(11), 2512–2527.   
Pedigo, K. L., & Marshall, V. (2009). Bribery: Australian managers’ experiences and responses when operating in international markets. Journal of Business Ethics, 87(1), 59–74.   
Peng, G. Z., & Beamish, P. W. (2008). The effect of national corporate responsibility environment on Japanese foreign direct investment. Journal of Business Ethics, 80(4), 677–695.   
Perez, M. F., Brada, J. C., & Drabek, Z. (2012). Illicit money flows as motives for FDI. Journal of Comparative Economics, 40(1), 108–126.   
Petrou, A. P. (2014). Bank foreign affiliate performance in the face of pervasive and arbitrary corruption. European Management Review, 11(3–4), 209–221.   
Petrou, A. P. (2015). Arbitrariness of corruption and foreign affiliate performance: A resource dependence perspective. Journal of World Business, 50(4), 826–837.   
Pfeffer, J., & Salancik, G. (1978). The external control of organi- zations: A resource dependence approach. New York: Harper & Row.   
Pontell, H. N., & Geis, G. L. (2007). International handbook of white-collar and corporate crime. New York, NY: Springer.   
Price, D., & de, S. (1965). Networks of scientific papers cited by me. Science, 149(March).   
Rodriguez, P. L., Siegel, D. S., Eden, L., & Hillman, A. (2006). Three lenses on the multinational enterprise: Politics, corruption, and corporate social responsibility. Journal of International Business Studies, 37, 733–746.   
Rodriguez, P., Uhlenbruck, K., & Eden, L. (2005). Government corruption and the entry strategies of multinationals. Academy of Management Review, 30(2), 383–396.   
Rosado-Serrano, A., Paul, J., & Dikova, D. (2018). International franchising: A literature review and research agenda. Journal of Business Research, 85, 238–257.   
Rose-Ackerman, S. (2002). “Grand” corruption and the ethics of global business. Journal of Banking & Finance, 26(9), 1889–1918.   
Roy, A., & Goll, I. (2014). Predictors of various facets of sustainability of nations: The role of cultural and economic factors. International Business Review, 23(5), 849–861.   
Roy, J., & Oliver, C. (2009). International joint venture partner selection: The role of the host-country legal environment. Journal of International Business Studies, 40(5), 779–801.   
Salipante, P., Notz, W., & Bigelow, J. (1982). A matrix approach to literature reviews. Research in Organizational Behavior, 4(1), 321–348.   
Sambharya, B. R., & Rasheed, A. A. (2015). Does economic freedom in host countries lead to increased foreign direct investment? Competitiveness Review, 25(1), 2–24.   
Sanyal, R. (2005). Determinants of bribery in international business: The cultural and economic factors. Journal of Business Ethics, 59(1), 139–145.   
Sanyal, R., & Guvenli, T. (2009). The propensity to bribe in international business: The relevance of cultural variables. Cross-Cultural Management: An International Journal, 16(3), 287–300.   
Sanyal, R., & Samanta, S. (2017). Bribery in international business in post-soviet union countries. Journal of East-West Business, 0(0), 1–15.   
Scott, W. R. (1995). Institutions and organizations. Thousand Oaks, CA: Sage.   
Shleifer, A., & Vishny, W. R. (1993). Corruption. The Quarterly Journal of Economics, 21(3), 137–162.   
Spalding, A. B. (2011). The irony of international business law: U.S. progressivism, China’s New Laissez Faire, and their impact in the developing world. UCLA Law Review, 59(2), 354–413.   
Srivastava, S. C., Teo, T. S. H., & Devaraj, S. (2016). You can’t bribe a computer: Dealing with the societal challenge of corruption through ICT. MIS Quarterly, 40(2), 511–526.   
Stulz, R. (2005). The limits of financial globalization. The Journal of Finance, LX(4), 1595–1638.   
Terjesen, S., Hessels, J., & Li, D. (2013). Comparative international entrepreneurship: A review and research agenda. Journal of Management, 42(1), 299–344.   
Tsalikis, J., & Latour, M. S. (1995). Bribery and extortion in international business: Ethical perceptions of greeks compared to americans. Journal of Business Ethics, 144(4), 249–264.   
Tuliao, K. V., & Chen, C. W. (2017). CEO duality and bribery: The roles of gender and national culture. Management Decision, 55(1), 218–231.   
Tunyi, A. A., & Ntim, C. G. (2016). Location advantages, governance quality, stock market development, and firm characteristics as antecedents of African M & As. Journal of International Management, 22(2), 147–167.   
Uhlenbruck, K., Rodriguez, P., Doh, J., & Eden, L. (2006). The impact of corruption on entry strategy: Evidence from telecommunication projects in emerging economies. Organization Science, 17(3), 402–414.   
Weber, J., & Getz, K. (2004). Buy bribes or bye-bye bribes: The future status of bribery in

# S. Bahoo, et al.

international commerce. Business Ethics Quarterly, 14(4), 695–711.   
Weber, R. P. (1990). Basic content analysis. Newbury Park, CA: Sage.   
Wenhao, C., & Ahmad, U. A. (2011). Implementing international laws to fight business bribery: Case of the Organization for Economic Co-operation and Development (OECD) anti-bribery convention. African Journal of Business Management, 5(32), 12392–12400.   
White, G. O., Guldiken, O., Hemphill, T. A., He, W., & Sharifi Khoobdeh, M. (2016). Trends in international strategic management research from 2000 to 2013: Text mining and bibliometric analyses. Management International Review, 56(1), 35–65.   
Windsor, D. (2004). The development of international business norms. Business Ethics Quarterly, 14(4), 729–754.   
Windsor, D. (2005). Formulating a moral core for international codes of conduct. International Corporate Responsibility Series, 2, 47–62.   
Wu, W., & Huang, C.-H. (2013). Motives and likelihood of bribery: An experimental study of managers in Taiwan. Ethics & Behavior, 23(4), 278–298.   
Xie, E., Reddy, K. S., & Liang, J. (2017). Country-specific determinants of cross-border mergers and acquisitions: A comprehensive review and future research directions. Journal of World Business, 52(2), 127–183.   
Yi, J., Teng, D., & Meng, S. (2017). Foreign ownership and bribery: Agency and institutional perspectives. International Business Review, 27(1), 34–45.   
Yim, R. H., Lu, J., & Choi, S. (2017). Different role of lobbying and bribery on the firm performance in emerging markets. Multinational Business Review, 25(3), 222–238.   
Zhu, B. (2017). MNCs, rents, and corruption: Evidence from China. American Journal of Political Science, 61(1), 84–99.

Salman Bahoo is a joint PhD candidate in Department of Economics and Statistics, University of Udine, Italy and School of Business and Law, University of Agder, Norway. His main research interest includes sovereign wealth funds, political risk, corruption, sovereign credit risk and international business. He is affiliated also with the Islamia University Bahawalpur, Pakistan.

Ilan Alon (PhD, Kent State University) is Professor of Strategy and International Marketing at the School of Business and Law at the University of Agder. He is also Editorin-Chief of the International Journal of Emerging Markets and the European Journal of International Management. Alon is a researcher in the field of international business with a focus on internationalization, modes of entry, political risk, cultural intelligence and emerging markets. His publications have appeared in journals, such as Harvard Business Review, Management International Review, International Business Review, Journal of International Marketing, and International Marketing Review. His books are published by Palgrave, Routledge, McGraw-Hill and others.

Andrea Paltrinieri is Assistant Professor of Banking and Finance in Department of Economics and Statistics at the University of Udine. He is Associate Editor of Islamic and Middle Eastern Finance and Management and at Editorial Review board of International Journal of Emerging Markets. His fields of research are in banking and finance area, with a focus on sovereign wealth funds, Islamic finance, emerging markets and commodities. He published in International Journal of Emerging Markets, Research in International Business and Finance, The Quarterly Review of Economics and Finance, Business Ethics: a European Review, The Geneva Papers.